/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.splines;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.splines.AdaptivePeriodicSpline;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AdaptivePeriodicSplines {
    final Specification spec;
    AdaptivePeriodicSpline aspline;
    final List<AdaptivePeriodicSpline.Step> steps = new ArrayList<AdaptivePeriodicSpline.Step>();
    int best;

    public AdaptivePeriodicSplines() {
        this.spec = Specification.DEF_SPEC;
    }

    public AdaptivePeriodicSplines(Specification spec) {
        this.spec = spec;
    }

    public void process(AdaptivePeriodicSpline aspline) {
        this.aspline = aspline;
        this.steps.clear();
        double ll0 = 0.0;
        double min = 0.0;
        this.best = -1;
        int cur = 0;
        for (double lambda = this.spec.getLambda0(); lambda <= this.spec.getLambda1(); lambda += this.spec.getLambdaStep()) {
            int nsel;
            aspline.process(lambda);
            AdaptivePeriodicSpline.Step result = aspline.result();
            if (result == null || (nsel = AdaptivePeriodicSpline.Step.selectedKnotsCount(result.getZ(), aspline.getSpecification())) < this.spec.minKnots || nsel < aspline.getSpecification().getFixedKnotsCount()) break;
            double ll = result.getLl();
            if (ll0 != 0.0 && !this.steps.stream().allMatch(s -> s.getLl() != ll)) continue;
            this.steps.add(result);
            double c = 0.0;
            switch (this.spec.criterion.ordinal()) {
                case 0: {
                    c = result.getAic();
                    break;
                }
                case 1: {
                    c = result.getBic();
                    break;
                }
                case 2: {
                    c = result.getEbic();
                }
            }
            if (min == 0.0 || c < min) {
                min = c;
                this.best = cur;
            }
            ll0 = result.getLl();
            ++cur;
        }
    }

    public int best() {
        return this.best;
    }

    public int resultsSize() {
        return this.steps.size();
    }

    public FastMatrix A() {
        FastMatrix A = FastMatrix.make(this.steps.size(), this.aspline.getSpecification().getKnots().length);
        DataBlockIterator rows = A.rowsIterator();
        for (AdaptivePeriodicSpline.Step step : this.steps) {
            rows.next().copy(DataBlock.of(step.getA()));
        }
        return A;
    }

    public FastMatrix Z() {
        FastMatrix Z = FastMatrix.make(this.steps.size(), this.aspline.getSpecification().getKnots().length);
        DataBlockIterator rows = Z.rowsIterator();
        for (AdaptivePeriodicSpline.Step step : this.steps) {
            rows.next().copy(DataBlock.of(step.getZ()));
        }
        return Z;
    }

    public FastMatrix W() {
        FastMatrix W = FastMatrix.make(this.steps.size(), this.aspline.getSpecification().getKnots().length);
        DataBlockIterator rows = W.rowsIterator();
        for (AdaptivePeriodicSpline.Step step : this.steps) {
            rows.next().copy(DataBlock.of(step.getW()));
        }
        return W;
    }

    public FastMatrix S() {
        FastMatrix S = FastMatrix.make(this.steps.size(), this.aspline.getSpecification().getKnots().length);
        DataBlockIterator rows = S.rowsIterator();
        for (AdaptivePeriodicSpline.Step step : this.steps) {
            rows.next().copy(DataBlock.of(step.getS()));
        }
        return S;
    }

    public AdaptivePeriodicSpline.Step result(int i) {
        return this.steps.get(i);
    }

    public List<AdaptivePeriodicSpline.Step> allResults() {
        return Collections.unmodifiableList(this.steps);
    }

    public AdaptivePeriodicSpline.Step result() {
        return this.steps.get(this.steps.size() - 1);
    }

    public AdaptivePeriodicSpline adaptiveSpline() {
        return this.aspline;
    }

    public int selectedKnotsCount() {
        if (this.best < 0) {
            throw new RuntimeException("Processing not done");
        }
        return this.selectedKnotsCount(this.best);
    }

    public int[] selectedKnotsPosition() {
        if (this.best < 0) {
            throw new RuntimeException("Processing not done");
        }
        return this.selectedKnotsPosition(this.best);
    }

    public double[] selectedKnots() {
        if (this.best < 0) {
            throw new RuntimeException("Processing not done");
        }
        return this.selectedKnots(this.best);
    }

    public int selectedKnotsCount(int pos) {
        double[] z = this.steps.get(pos).getZ();
        if (z == null) {
            return this.aspline.getSpecification().getKnots().length;
        }
        return AdaptivePeriodicSpline.Step.selectedKnotsCount(z, this.aspline.getSpecification());
    }

    public int[] selectedKnotsPosition(int pos) {
        double[] z = this.steps.get(pos).getZ();
        if (z == null) {
            return null;
        }
        return AdaptivePeriodicSpline.Step.selectedKnotsPosition(z, this.aspline.getSpecification());
    }

    public double[] selectedKnots(int pos) {
        double[] z = this.steps.get(pos).getZ();
        if (z == null) {
            return null;
        }
        return AdaptivePeriodicSpline.Step.selectedKnots(z, this.aspline.getSpecification());
    }

    public static final class Specification {
        public static final Specification DEF_SPEC = Specification.builder().build();
        private final double lambda0;
        private final double lambda1;
        private final double lambdaStep;
        private final int minKnots;
        private final Criterion criterion;

        public static Builder builder() {
            return new Builder().minKnots(0).lambda0(0.0).lambda1(10.0).lambdaStep(0.025).criterion(Criterion.BIC);
        }

        @Generated
        Specification(double lambda0, double lambda1, double lambdaStep, int minKnots, Criterion criterion) {
            this.lambda0 = lambda0;
            this.lambda1 = lambda1;
            this.lambdaStep = lambdaStep;
            this.minKnots = minKnots;
            this.criterion = criterion;
        }

        @Generated
        public double getLambda0() {
            return this.lambda0;
        }

        @Generated
        public double getLambda1() {
            return this.lambda1;
        }

        @Generated
        public double getLambdaStep() {
            return this.lambdaStep;
        }

        @Generated
        public int getMinKnots() {
            return this.minKnots;
        }

        @Generated
        public Criterion getCriterion() {
            return this.criterion;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Specification)) {
                return false;
            }
            Specification other = (Specification)o;
            if (Double.compare(this.getLambda0(), other.getLambda0()) != 0) {
                return false;
            }
            if (Double.compare(this.getLambda1(), other.getLambda1()) != 0) {
                return false;
            }
            if (Double.compare(this.getLambdaStep(), other.getLambdaStep()) != 0) {
                return false;
            }
            if (this.getMinKnots() != other.getMinKnots()) {
                return false;
            }
            Criterion this$criterion = this.getCriterion();
            Criterion other$criterion = other.getCriterion();
            return !(this$criterion == null ? other$criterion != null : !((Object)((Object)this$criterion)).equals((Object)other$criterion));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $lambda0 = Double.doubleToLongBits(this.getLambda0());
            result = result * 59 + (int)($lambda0 >>> 32 ^ $lambda0);
            long $lambda1 = Double.doubleToLongBits(this.getLambda1());
            result = result * 59 + (int)($lambda1 >>> 32 ^ $lambda1);
            long $lambdaStep = Double.doubleToLongBits(this.getLambdaStep());
            result = result * 59 + (int)($lambdaStep >>> 32 ^ $lambdaStep);
            result = result * 59 + this.getMinKnots();
            Criterion $criterion = this.getCriterion();
            result = result * 59 + ($criterion == null ? 43 : ((Object)((Object)$criterion)).hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "AdaptivePeriodicSplines.Specification(lambda0=" + this.getLambda0() + ", lambda1=" + this.getLambda1() + ", lambdaStep=" + this.getLambdaStep() + ", minKnots=" + this.getMinKnots() + ", criterion=" + String.valueOf((Object)this.getCriterion()) + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private double lambda0;
            @Generated
            private double lambda1;
            @Generated
            private double lambdaStep;
            @Generated
            private int minKnots;
            @Generated
            private Criterion criterion;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder lambda0(double lambda0) {
                this.lambda0 = lambda0;
                return this;
            }

            @Generated
            public @NonNull Builder lambda1(double lambda1) {
                this.lambda1 = lambda1;
                return this;
            }

            @Generated
            public @NonNull Builder lambdaStep(double lambdaStep) {
                this.lambdaStep = lambdaStep;
                return this;
            }

            @Generated
            public @NonNull Builder minKnots(int minKnots) {
                this.minKnots = minKnots;
                return this;
            }

            @Generated
            public @NonNull Builder criterion(Criterion criterion) {
                this.criterion = criterion;
                return this;
            }

            @Generated
            public @NonNull Specification build() {
                return new Specification(this.lambda0, this.lambda1, this.lambdaStep, this.minKnots, this.criterion);
            }

            @Generated
            public @NonNull String toString() {
                return "AdaptivePeriodicSplines.Specification.Builder(lambda0=" + this.lambda0 + ", lambda1=" + this.lambda1 + ", lambdaStep=" + this.lambdaStep + ", minKnots=" + this.minKnots + ", criterion=" + String.valueOf((Object)this.criterion) + ")";
            }
        }
    }

    public static enum Criterion {
        AIC,
        BIC,
        EBIC;

    }
}

