/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.TsVariable;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class TsVariableFactory
implements RegressionVariableFactory<TsVariable> {
    static final String NOTFOUND = ": data not found";
    static final String TOOSHORT = ": series too short. Zeroes added";
    static TsVariableFactory FACTORY = new TsVariableFactory();

    private TsVariableFactory() {
    }

    @Override
    public boolean fill(TsVariable var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        TsData v = var.getData();
        if (v == null) {
            if (log != null) {
                log.warning(var.getId() + NOTFOUND);
            }
            return false;
        }
        TsDomain curdom = v.getDomain();
        int istart = curdom.getStartPeriod().until(start);
        int n = buffer.getRowsCount();
        int m = curdom.getLength();
        int iend = istart + n;
        int jstart = 0;
        int jend = n;
        boolean ok = true;
        if (istart < 0) {
            jstart = -istart;
            istart = 0;
            ok = false;
        }
        if (iend > m) {
            jend -= iend - m;
            iend = m;
            ok = false;
        }
        if (!ok && log != null) {
            log.warning(var.getId() + TOOSHORT);
        }
        if (jstart < jend) {
            buffer.column(0).range(jstart, jend).copy(v.getValues().range(istart, iend));
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(TsVariable var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

