/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.estimation;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunction;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionPoint;
import jdplus.toolkit.base.core.regarima.RegArmaModel;
import jdplus.toolkit.base.core.regarima.estimation.ArmaFunction;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;

class ArmaEvaluation<S extends IArimaModel>
implements ISsqFunctionPoint,
IFunctionPoint {
    final ArmaFunction<S> fn;
    final DoubleSeq p;
    final S arma;
    final ConcentratedLikelihoodWithMissing ll;

    public ArmaEvaluation(ArmaFunction<S> fn, DoubleSeq p) {
        this.fn = fn;
        this.p = p;
        this.arma = (IArimaModel)fn.mapping.map(p);
        RegArmaModel<S> regarma = new RegArmaModel<S>(fn.dy, this.arma, fn.nmissing, fn.x);
        this.ll = fn.cll.compute(regarma);
    }

    @Override
    public DoubleSeq getE() {
        return this.fn.errors.apply(this.ll);
    }

    @Override
    public DoubleSeq getParameters() {
        return this.p;
    }

    @Override
    public double getSsqE() {
        return this.fn.ssqll.applyAsDouble(this.ll);
    }

    @Override
    public double getValue() {
        return this.fn.ll.applyAsDouble(this.ll);
    }

    @Override
    public ISsqFunction getSsqFunction() {
        return this.fn;
    }

    @Override
    public IFunction getFunction() {
        return this.fn;
    }
}

