/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.outlier;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import lombok.Generated;

public final class CriticalValueComputer {
    public static IntToDoubleFunction simpleComputer() {
        return len -> {
            double cv = len <= 50 ? 3.3 : (len < 450 ? 3.3 + 0.0025 * (double)(len - 50) : 4.3);
            return cv;
        };
    }

    public static IntToDoubleFunction advancedComputer() {
        return CriticalValueComputer.advancedComputer(0.05);
    }

    public static IntToDoubleFunction advancedComputer(double threshold) {
        return len -> {
            int i;
            Normal normal = new Normal();
            if (len == 1) {
                return normal.getProbabilityInverse(threshold / 2.0, ProbabilityType.Upper);
            }
            double n = len;
            double[] y = new double[3];
            int[] x = new int[]{2, 100, 200};
            FastMatrix X = FastMatrix.square(3);
            for (i = 0; i < 3; ++i) {
                X.set(i, 0, 1.0);
                X.set(i, 2, Math.sqrt(2.0 * Math.log(x[i])));
                X.set(i, 1, (Math.log(Math.log(x[i])) + Math.log(Math.PI * 4)) / (2.0 * X.get(i, 2)));
            }
            y[0] = normal.getProbabilityInverse((1.0 + Math.sqrt(1.0 - threshold)) / 2.0, ProbabilityType.Lower);
            for (i = 1; i < 3; ++i) {
                y[i] = CriticalValueComputer.calcVAL(x[i], threshold);
            }
            LinearSystemSolver.robustSolver().solve(X, DataBlock.of(y));
            double acv = Math.sqrt(2.0 * Math.log(n));
            double bcv = (Math.log(Math.log(n)) + Math.log(Math.PI * 4)) / (2.0 * acv);
            return y[0] + y[1] * bcv + y[2] * acv;
        };
    }

    private static double calcVAL(int nvals, double eps) {
        if (nvals == 1) {
            return 1.96;
        }
        double n = nvals;
        double pmod = 2.0 - Math.sqrt(1.0 + eps);
        double acv = Math.sqrt(2.0 * Math.log(n));
        double bcv = acv - (Math.log(Math.log(n)) + Math.log(Math.PI * 4)) / (2.0 * acv);
        double xcv = -Math.log(-0.5 * Math.log(pmod));
        return xcv / acv + bcv;
    }

    @Generated
    private CriticalValueComputer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

