/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.akf;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.akf.AkfToolkit;
import jdplus.toolkit.base.core.ssf.akf.AugmentedState;
import jdplus.toolkit.base.core.ssf.akf.DefaultAugmentedFilteringResults;
import jdplus.toolkit.base.core.ssf.akf.DefaultQFilteringResults;
import jdplus.toolkit.base.core.ssf.akf.QAugmentation;
import jdplus.toolkit.base.core.ssf.univariate.ISmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.OrdinarySmoother;

public class AugmentedSmoother {
    private AugmentedState state;
    private ISsfDynamics dynamics;
    private ISsfLoading loading;
    private ISmoothingResults srslts;
    private DefaultAugmentedFilteringResults frslts;
    private double err;
    private double errVariance;
    private double u;
    private double uc;
    private double ucVariance;
    private DataBlock M;
    private DataBlock K;
    private DataBlock E;
    private DataBlock U;
    private DataBlock R;
    private DataBlock Rc;
    private FastMatrix N;
    private FastMatrix Nc;
    private FastMatrix Rd;
    private FastMatrix B;
    private FastMatrix V;
    private FastMatrix RNA;
    private FastMatrix S;
    private FastMatrix Psi;
    private DataBlock delta;
    private boolean missing;
    private boolean hasinfo;
    private boolean calcvar = true;

    public boolean process(ISsf ssf, ISsfData data, ISmoothingResults sresults) {
        DefaultQFilteringResults fresults = AkfToolkit.filter(ssf, data, true, true);
        return this.process(ssf, data.length(), fresults, sresults);
    }

    public boolean process(ISsf ssf, int endpos, DefaultQFilteringResults results, ISmoothingResults sresults) {
        this.frslts = results;
        this.srslts = sresults;
        this.initFilter(ssf);
        this.initSmoother(ssf, endpos);
        int t = results.getCollapsingPosition();
        if (t == 0) {
            QAugmentation q = results.getAugmentation();
            FastMatrix B = q.B();
            this.S = q.a().deepClone();
            this.delta = q.b().deepClone();
            this.delta.chs();
            LowerTriangularMatrix.solvexL(this.S, this.delta);
            if (this.N != null) {
                this.Psi = FastMatrix.identity(this.S.getColumnsCount());
                LowerTriangularMatrix.solveXL(this.S, this.Psi);
                LowerTriangularMatrix.solveLtX(this.S, this.Psi);
            }
            return this.processNoCollapsing(endpos);
        }
        this.ordinarySmoothing(ssf, results.getCollapsingPosition(), endpos);
        if (t > 0) {
            this.calcSmoothedDiffuseEffects(results.getAugmentation());
            while (--t >= 0) {
                this.iterate(t);
                if (!this.hasinfo) continue;
                this.srslts.saveSmoothation(t, this.uc, this.ucVariance);
                this.srslts.saveR(t, this.Rc, this.Nc);
                this.srslts.save(t, this.state, StateInfo.Smoothed);
            }
        }
        return true;
    }

    public boolean process(ISsf ssf, int endpos, DefaultAugmentedFilteringResults results, FastMatrix S, DoubleSeq delta, ISmoothingResults sresults) {
        this.frslts = results;
        this.srslts = sresults;
        this.initFilter(ssf);
        this.initSmoother(ssf, endpos);
        this.delta = DataBlock.of(delta);
        this.S = S;
        if (this.N != null) {
            this.Psi = FastMatrix.identity(S.getColumnsCount());
            LowerTriangularMatrix.solveXL(this.S, this.Psi);
            LowerTriangularMatrix.solveLtX(this.S, this.Psi);
        }
        return this.processNoCollapsing(endpos);
    }

    public ISmoothingResults getResults() {
        return this.srslts;
    }

    private void initSmoother(ISsf ssf, int end) {
        ISsfInitialization initialization = ssf.initialization();
        int dim = initialization.getStateDim();
        int nd = initialization.getDiffuseDim();
        this.state = new AugmentedState(dim, nd);
        this.R = DataBlock.make(dim);
        this.Rc = DataBlock.make(dim);
        this.M = DataBlock.make(dim);
        this.K = DataBlock.make(dim);
        this.E = DataBlock.make(nd);
        this.U = DataBlock.make(nd);
        this.Rd = FastMatrix.make(dim, nd);
        this.B = FastMatrix.make(dim, nd);
        if (this.calcvar) {
            this.N = FastMatrix.square(dim);
            this.Nc = FastMatrix.square(dim);
            this.V = FastMatrix.make(dim, nd);
            this.RNA = FastMatrix.make(dim, nd);
        }
    }

    private void loadInfo(int pos) {
        DataBlock fa;
        this.missing = this.frslts.isMissing(pos);
        if (!this.missing) {
            this.err = this.frslts.error(pos);
            this.errVariance = this.frslts.errorVariance(pos);
            this.E.copy(this.frslts.E(pos));
            this.M.copy(this.frslts.M(pos));
            if (this.errVariance != 0.0) {
                this.K.copy(this.frslts.M(pos));
                this.dynamics.TX(pos, this.K);
                this.K.div(this.errVariance);
            }
        }
        boolean bl = this.hasinfo = (fa = this.frslts.a(pos)) != null;
        if (!this.hasinfo) {
            return;
        }
        this.state.a().copy(fa);
        if (this.calcvar) {
            this.state.restoreB(this.frslts.B(pos));
            this.state.P().copy(this.frslts.P(pos));
        }
    }

    private void iterate(int pos) {
        this.loadInfo(pos);
        this.iterateSmoothation(pos);
        this.iterateR(pos);
        this.calcB(pos);
        this.updateA(pos);
        if (this.calcvar) {
            this.iterateN(pos);
            this.calcV();
            this.updateP();
        }
    }

    private void calcB(int pos) {
        DataBlockIterator prows;
        DataBlockIterator bcolumns = this.B.columnsIterator();
        DataBlockIterator rcolumns = this.Rd.columnsIterator();
        DataBlockIterator acolumns = this.calcvar ? this.state.B().columnsIterator() : this.frslts.B(pos).columnsIterator();
        DataBlockIterator dataBlockIterator = prows = this.calcvar ? this.state.P().rowsIterator() : this.frslts.P(pos).rowsIterator();
        while (bcolumns.hasNext() && rcolumns.hasNext() && acolumns.hasNext()) {
            prows.reset();
            DataBlock uc = bcolumns.next();
            uc.product(prows, rcolumns.next());
            uc.add(acolumns.next());
        }
    }

    private void calcV() {
        DataBlockIterator rnacolumns = this.RNA.columnsIterator();
        DataBlockIterator rcolumns = this.Rd.columnsIterator();
        DataBlockIterator acolumns = this.state.B().columnsIterator();
        while (rnacolumns.hasNext() && rcolumns.hasNext() && acolumns.hasNext()) {
            DataBlock rnac = rnacolumns.next();
            rnac.product(this.N.rowsIterator(), acolumns.next());
            rnac.add(rcolumns.next());
        }
        DataBlockIterator vcolumns = this.V.columnsIterator();
        rnacolumns.reset();
        while (vcolumns.hasNext() && rnacolumns.hasNext()) {
            vcolumns.next().product(this.state.P().rowsIterator(), rnacolumns.next());
        }
    }

    private void updateA(int pos) {
        DataBlock a = this.state.a();
        a.addProduct(this.R, this.calcvar ? this.state.P().columnsIterator() : this.frslts.P(pos).columnsIterator());
        this.mcorrection(a, this.B);
    }

    private void updateP() {
        FastMatrix P = this.state.P();
        FastMatrix PNP = SymmetricMatrix.XtSX(this.N, P);
        P.sub(PNP);
        this.vcorrection(P, this.B, this.V);
        P.apply(z -> Math.abs(z) < 1.0E-9 ? 0.0 : z);
    }

    private void xL(int pos, DataBlock x) {
        this.dynamics.XT(pos, x);
        double q = x.dot(this.M);
        this.loading.XpZd(pos, x, -q / this.errVariance);
    }

    private void XL(int pos, DataBlockIterator X) {
        while (X.hasNext()) {
            this.xL(pos, X.next());
        }
    }

    private void iterateN(int pos) {
        if (!this.missing) {
            this.XL(pos, this.N.rowsIterator());
            this.XL(pos, this.N.columnsIterator());
            this.loading.VpZdZ(pos, this.N, 1.0 / this.errVariance);
        } else {
            this.dynamics.MT(pos, this.N);
            this.dynamics.TtM(pos, this.N);
        }
        SymmetricMatrix.reenforceSymmetry(this.N);
        FastMatrix A = this.frslts.B(pos);
        FastMatrix NA = GeneralMatrix.AB(this.N, A);
        NA.add(this.Rd);
        this.Nc.set(0.0);
        this.vcorrection(this.Nc, this.Rd.deepClone(), NA);
        this.Nc.chs();
        this.Nc.add(this.N);
        SymmetricMatrix.reenforceSymmetry(this.Nc);
    }

    private void iterateR(int pos) {
        this.dynamics.XT(pos, this.R);
        this.dynamics.TtM(pos, this.Rd);
        if (!this.missing && this.errVariance != 0.0) {
            this.loading.XpZd(pos, this.R, this.u);
            DataBlockIterator rcols = this.Rd.columnsIterator();
            DoubleSeqCursor.OnMutable ucur = this.U.cursor();
            while (rcols.hasNext()) {
                this.loading.XpZd(pos, rcols.next(), ucur.getAndNext());
            }
        }
        this.Rc.copy(this.R);
        this.Rc.addProduct(this.Rd.rowsIterator(), this.delta);
    }

    private void iterateSmoothation(int pos) {
        if (this.missing) {
            this.u = Double.NaN;
            this.uc = Double.NaN;
            this.U.set(Double.NaN);
            this.ucVariance = Double.NaN;
            return;
        }
        if (this.errVariance != 0.0) {
            this.u = this.err / this.errVariance - this.R.dot(this.K);
            this.U.product(this.K, this.Rd.columnsIterator());
            this.U.chs();
            this.U.addAY(1.0 / this.errVariance, this.E);
            this.uc = this.u + this.U.dot(this.delta);
            if (this.calcvar) {
                FastMatrix A = this.frslts.B(pos);
                FastMatrix NA = GeneralMatrix.AB(this.N, A);
                NA.add(this.Rd);
                DataBlock C = DataBlock.make(this.U.length());
                C.product(this.K, NA.columnsIterator());
                C.chs();
                this.ucVariance = 1.0 / this.errVariance + QuadraticForm.apply(this.N, this.K) - this.vcorrection(this.U.deepClone(), C);
                if (this.ucVariance < (double)1.110223E-16f) {
                    this.ucVariance = 0.0;
                }
                if (this.ucVariance == 0.0 && Math.abs(this.uc) < Constants.getEpsilon()) {
                    this.uc = 0.0;
                }
            }
        }
    }

    private void initFilter(ISsf ssf) {
        this.dynamics = ssf.dynamics();
        this.loading = ssf.loading();
    }

    public void setCalcVariances(boolean b) {
        this.calcvar = b;
    }

    public boolean isCalcVariances() {
        return this.calcvar;
    }

    private void ordinarySmoothing(ISsf ssf, int startpos, int endpos) {
        OrdinarySmoother smoother = OrdinarySmoother.builder(ssf).calcVariance(this.calcvar).build();
        smoother.process(startpos, endpos, this.frslts, this.srslts);
        this.R.copy(smoother.getFinalR());
        this.Rc.copy(smoother.getFinalR());
        if (this.calcvar) {
            this.N.copy(smoother.getFinalN());
            this.Nc.copy(smoother.getFinalN());
        }
    }

    private void calcSmoothedDiffuseEffects(QAugmentation q) {
        FastMatrix B = q.B();
        this.S = q.a().deepClone();
        this.delta = DataBlock.make(B.getColumnsCount());
        this.delta.product(B.columnsIterator(), this.R);
        this.delta.sub(q.b());
        LowerTriangularMatrix.solvexL(this.S, this.delta);
        if (this.N != null) {
            this.Psi = SymmetricMatrix.XtSX(this.N, B);
            this.Psi.chs();
            this.Psi.diagonal().add(1.0);
            LowerTriangularMatrix.solveXL(this.S, this.Psi);
            LowerTriangularMatrix.solveLtX(this.S, this.Psi);
        }
    }

    public DefaultAugmentedFilteringResults getFilteringResults() {
        return this.frslts;
    }

    private void mcorrection(DataBlock x, FastMatrix B) {
        x.addProduct(B.rowsIterator(), this.delta);
    }

    private void vcorrection(FastMatrix V, FastMatrix B, FastMatrix C) {
        FastMatrix BPsiB = SymmetricMatrix.XSXt(this.Psi, B);
        V.add(BPsiB);
        LowerTriangularMatrix.solveXLt(this.S, B);
        LowerTriangularMatrix.solveXLt(this.S, C);
        FastMatrix UV = GeneralMatrix.ABt(B, C);
        V.sub(UV);
        V.subTranspose(UV);
        SymmetricMatrix.reenforceSymmetry(V);
    }

    private double vcorrection(DataBlock B, DataBlock C) {
        double v = QuadraticForm.apply(this.Psi, B);
        LowerTriangularMatrix.solveLx(this.S, B);
        LowerTriangularMatrix.solveLx(this.S, C);
        return v - 2.0 * B.dot(C);
    }

    private boolean processNoCollapsing(int endpos) {
        int t = endpos;
        while (--t >= 0) {
            this.iterate(t);
            if (!this.hasinfo) continue;
            this.srslts.saveSmoothation(t, this.uc, this.ucVariance);
            this.srslts.saveR(t, this.Rc, this.Nc);
            this.srslts.save(t, this.state, StateInfo.Smoothed);
        }
        return true;
    }
}

