/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.MatrixResults;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.dk.BaseDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.dk.DiffuseState;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;

public class DefaultDiffuseFilteringResults
extends BaseDiffuseFilteringResults {
    private final MatrixResults Pi;

    private DefaultDiffuseFilteringResults(boolean var) {
        super(var);
        this.Pi = var ? new MatrixResults() : null;
    }

    public static DefaultDiffuseFilteringResults full() {
        return new DefaultDiffuseFilteringResults(true);
    }

    public static DefaultDiffuseFilteringResults light() {
        return new DefaultDiffuseFilteringResults(false);
    }

    @Override
    public void prepare(ISsf ssf, int start, int end) {
        super.prepare(ssf, start, end);
        ISsfInitialization initialization = ssf.initialization();
        int dim = initialization.getStateDim();
        int n = initialization.getDiffuseDim();
        if (this.Pi != null) {
            this.Pi.prepare(dim, start, n);
        }
    }

    @Override
    public void save(int t, DiffuseState state, StateInfo info) {
        if (info != StateInfo.Forecast) {
            return;
        }
        super.save(t, state, info);
        if (this.Pi != null) {
            this.Pi.save(t, state.Pi());
        }
    }

    public FastMatrix Pi(int pos) {
        return this.Pi.matrix(pos);
    }

    @Override
    public void clear() {
        super.clear();
        this.Pi.clear();
    }
}

