/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.multivariate;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsfData;

public class ExtendedMultivariateSsfData
implements IMultivariateSsfData {
    private final int nbcasts;
    private final int nfcasts;
    private final IMultivariateSsfData data;

    public ExtendedMultivariateSsfData(IMultivariateSsfData data, int bcasts, int fcasts) {
        this.data = data;
        this.nfcasts = fcasts;
        this.nbcasts = bcasts;
    }

    @Override
    public double get(int pos, int v) {
        if (pos < this.nbcasts) {
            return Double.NaN;
        }
        return this.data.get(pos - this.nbcasts, v);
    }

    public int getBackcastsCount() {
        return this.nbcasts;
    }

    @Override
    public int getObsCount() {
        return this.nbcasts + this.nfcasts + this.data.getObsCount();
    }

    public int getForecastsCount() {
        return this.nfcasts;
    }

    @Override
    public boolean isMissing(int pos, int v) {
        if (pos < this.nbcasts) {
            return true;
        }
        return this.data.isMissing(pos - this.nbcasts, v);
    }

    @Override
    public DoubleSeq get(int pos) {
        if (pos < this.nbcasts) {
            return DoubleSeq.empty();
        }
        return this.data.get(pos - this.nbcasts);
    }

    @Override
    public boolean isConstraint(int pos, int v) {
        if (pos < this.nbcasts) {
            return false;
        }
        return this.data.isConstraint(pos - this.nbcasts, v);
    }

    @Override
    public int getVarsCount() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

