/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihood;
import lombok.NonNull;

final class InternalConcentratedLikelihood
implements ConcentratedLikelihood {
    private final int n;
    private final double ll;
    private final double ssqerr;
    private final double ldet;
    private final double[] res;
    private final double[] b;
    private final FastMatrix bvar;
    private final boolean scalingFactor;

    InternalConcentratedLikelihood(int n, double ssqerr, double ldet, double[] res, double[] b, FastMatrix bvar, boolean scalingFactor) {
        this.n = n;
        this.ldet = ldet;
        this.ssqerr = ssqerr;
        this.b = b;
        this.bvar = bvar;
        this.res = res;
        this.scalingFactor = scalingFactor;
        this.ll = scalingFactor ? -0.5 * ((double)n * Constants.LOGTWOPI + (double)n * (1.0 + Math.log(ssqerr / (double)n)) + ldet) : -0.5 * ((double)n * Constants.LOGTWOPI + ssqerr + ldet);
    }

    @Override
    public boolean isScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public double logDeterminant() {
        return this.ldet;
    }

    @Override
    public double logLikelihood() {
        return this.ll;
    }

    @Override
    public int dim() {
        return this.n;
    }

    @Override
    public int nx() {
        return this.b.length;
    }

    @Override
    public DoubleSeq e() {
        return DoubleSeq.of((double[])this.res);
    }

    @Override
    @NonNull
    public DoubleSeq coefficients() {
        return DoubleSeq.of((double[])this.b);
    }

    @Override
    public double coefficient(int pos) {
        return this.b[pos];
    }

    @Override
    @NonNull
    public FastMatrix unscaledCovariance() {
        if (this.bvar == null) {
            return FastMatrix.EMPTY;
        }
        return this.bvar;
    }

    @Override
    public double ssq() {
        return this.ssqerr;
    }

    @Override
    public int degreesOfFreedom() {
        return this.n - this.nx();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("log-likelihood: ").append(this.ll).append(", sigma2: ").append(this.ssqerr / (double)this.n);
        return builder.toString();
    }
}

