/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.stats.StatException;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class TestOfUpDownRuns {
    private int nruns;
    private int[] runLengths;
    private DoubleSeq obs;

    private static double dfact(double x, int k) {
        for (int i = 2; i <= k; ++i) {
            if (x == 0.0) {
                return 0.0;
            }
            x /= (double)i;
        }
        return x;
    }

    public TestOfUpDownRuns(DoubleSeq data) {
        this.obs = data.select(x -> Double.isFinite(x));
    }

    private void races() {
        if (this.runLengths != null) {
            return;
        }
        int n = this.obs.length();
        this.runLengths = new int[n - 1];
        this.nruns = 1;
        if (n < 2) {
            throw new StatException("Not enough data");
        }
        DoubleSeqCursor reader = this.obs.cursor();
        double o0 = reader.getAndNext();
        double o1 = reader.getAndNext();
        boolean up = o1 >= o0;
        int curlength = 1;
        for (int i = 2; i < n; ++i) {
            boolean curup;
            o0 = o1;
            o1 = reader.getAndNext();
            boolean bl = curup = o1 >= o0;
            if (up != curup) {
                ++this.nruns;
                up = curup;
                int n2 = curlength - 1;
                this.runLengths[n2] = this.runLengths[n2] + 1;
                curlength = 1;
                continue;
            }
            ++curlength;
        }
        int n3 = curlength - 1;
        this.runLengths[n3] = this.runLengths[n3] + 1;
    }

    public int runsCount(int length) {
        return length <= 0 ? this.nruns : this.runLengths[length - 1];
    }

    public StatisticalTest testLength() {
        this.races();
        int n = this.obs.length();
        double x = 0.0;
        for (int i = 1; i < n; ++i) {
            double ei = 0.0;
            if (i != n - 1) {
                ei = 2 * (n * (i * i + 3 * i + 1) - (i * i * i + 3 * i * i - i - 4));
                ei = TestOfUpDownRuns.dfact(ei, i + 3);
            } else {
                ei = TestOfUpDownRuns.dfact(2.0, n);
            }
            double oi = this.runLengths[i - 1];
            if (oi == 0.0) {
                x += ei;
                continue;
            }
            if (ei != 0.0) {
                x += (oi - ei) / ei * (oi - ei);
                continue;
            }
            x += 999999.0;
        }
        Chi2 dist = new Chi2(n - 1);
        return TestsUtility.testOf(x, dist, TestType.Upper);
    }

    public StatisticalTest testNumber() {
        this.races();
        double n = this.obs.length();
        double E = (2.0 * n - 1.0) / 3.0;
        double V = (16.0 * n - 29.0) / 90.0;
        Normal dist = new Normal();
        return TestsUtility.testOf(((double)this.nruns - E) / Math.sqrt(V), dist, TestType.TwoSided);
    }
}

