/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.simplets.analysis;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleList;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.timeseries.simplets.analysis.MovingProcessingFacade;

public class MovingProcessing<T> {
    private final MovingProcessingFacade m_processing;

    public MovingProcessing(TsDomain domain, Function<TsDomain, T> processing) {
        this.m_processing = new MovingProcessingFacade<T>(domain, processing);
    }

    public Function<TsDomain, T> getProcessing() {
        return this.m_processing.getProcessing();
    }

    public TsDomain getReferenceDomain() {
        return this.m_processing.getDomain();
    }

    public T getReferenceInfo() {
        return this.m_processing.tsInfo(this.m_processing.getDomain());
    }

    public TsPeriod getStart() {
        return this.m_processing.getStart();
    }

    public int getWindowIncrement() {
        return this.m_processing.getIncrement();
    }

    public int getWindowLength() {
        return this.m_processing.getLength();
    }

    public Map<TsDomain, Double> movingInfo(ToDoubleFunction<T> extractor) {
        return this.movingInfo(this.m_processing.getStart(), this.m_processing.getLength(), this.m_processing.getIncrement(), extractor);
    }

    public Map<TsDomain, Double> movingInfo(TsPeriod start, int length, int increment, ToDoubleFunction<T> extractor) {
        LinkedHashMap<TsDomain, Double> map = new LinkedHashMap<TsDomain, Double>();
        DoubleList rslt = new DoubleList();
        TsDomain domain = TsDomain.of((TsPeriod)start, (int)length);
        while (!domain.end().isAfter(this.m_processing.getDomain().end())) {
            double data = this.m_processing.getData(domain, extractor);
            if (Double.isFinite(data)) {
                map.put(domain, data);
            }
            domain = domain.move(increment);
        }
        return map;
    }

    public void setStart(TsPeriod value) {
        this.m_processing.setStart(value);
    }

    public void setWindowIncrement(int value) {
        this.m_processing.setIncrement(value);
    }

    public void setWindowLength(int value) {
        this.m_processing.setLength(value);
    }
}

