/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ucarima;

import java.util.ArrayList;
import java.util.List;
import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.ucarima.IRootSelector;
import jdplus.toolkit.base.core.ucarima.RootDecomposer;
import jdplus.toolkit.base.core.ucarima.SimpleModelDecomposer;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;

public class ModelDecomposer {
    private final List<SimpleModelDecomposer> m_smds = new ArrayList<SimpleModelDecomposer>();

    public void add(IRootSelector selector) {
        RootDecomposer decomposer = new RootDecomposer(selector);
        this.m_smds.add(decomposer);
    }

    public void add(SimpleModelDecomposer smd) {
        this.m_smds.add(smd);
    }

    public void clear() {
        this.m_smds.clear();
    }

    public UcarimaModel decompose(IArimaModel m) {
        try {
            ArimaModel arima = ArimaModel.of(m);
            if (arima == null) {
                return null;
            }
            int n = this.m_smds.size();
            ArimaModel[] cmps = new ArimaModel[n + 1];
            if (n == 0) {
                cmps[0] = arima;
            } else {
                ArimaModel cur = arima;
                for (int i = 0; i < n; ++i) {
                    SimpleModelDecomposer smd = this.m_smds.get(i);
                    smd.setModel(cur);
                    cmps[i] = smd.getSignal();
                    cur = smd.getNoise();
                }
                cmps[n] = cur;
            }
            return new UcarimaModel(m, cmps);
        }
        catch (ArimaException ex) {
            return null;
        }
    }
}

