/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ucarima;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.BartlettApproximation;
import jdplus.toolkit.base.core.arima.LinearProcess;
import jdplus.toolkit.base.core.arima.StationaryTransformation;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovEstimators;

public final class WienerKolmogorovDiagnostics {
    private FastMatrix m_tac;
    private FastMatrix m_eac;
    private FastMatrix m_sdvar;
    private ArimaModel[] m_stcmp;
    private LinearProcess[] m_stest;
    private double[][] m_stdata;

    public static WienerKolmogorovDiagnostics make(UcarimaModel model, double err, double[][] data, int[] cmps) {
        int n = cmps.length;
        if (data.length != n) {
            return null;
        }
        WienerKolmogorovDiagnostics diags = new WienerKolmogorovDiagnostics();
        WienerKolmogorovEstimators wk = new WienerKolmogorovEstimators(model);
        double[][] stdata = new double[n][];
        ArimaModel[] stmodels = new ArimaModel[n];
        LinearProcess[] emodels = new LinearProcess[n];
        int ndata = data[0].length;
        for (int i = 0; i < n; ++i) {
            if (data[i] == null) continue;
            ArimaModel cur = null;
            boolean signal = cmps[i] > 0;
            int icmp = signal ? cmps[i] - 1 : -cmps[i] - 1;
            cur = model.getComponent(icmp);
            if (cur.isNull()) continue;
            if (!signal) {
                cur = model.getComplement(icmp);
            }
            StationaryTransformation<ArimaModel> stmodel = cur.stationaryTransformation();
            double[] curst = new double[ndata - stmodel.getUnitRoots().getDegree()];
            DataBlock out = DataBlock.of(curst);
            stmodel.getUnitRoots().apply(DataBlock.of(data[i]), out);
            out.sub(out.sum() / (double)out.length());
            stdata[i] = curst;
            emodels[i] = (LinearProcess)wk.finalStationaryEstimator(icmp, signal).getStationaryModel();
            stmodels[i] = stmodel.getStationaryModel();
        }
        if (diags.test(emodels, err, stdata)) {
            diags.m_stcmp = stmodels;
            diags.m_stest = emodels;
            diags.m_stdata = stdata;
            return diags;
        }
        return null;
    }

    private WienerKolmogorovDiagnostics() {
    }

    private boolean test(LinearProcess[] stmodels, double err, double[][] stdata) {
        try {
            int n = stmodels.length;
            if (n != stdata.length) {
                return false;
            }
            this.m_eac = FastMatrix.square(n);
            this.m_tac = FastMatrix.square(n);
            this.m_sdvar = FastMatrix.square(n);
            for (int i = 0; i < n; ++i) {
                if (stmodels[i] == null) continue;
                double[] itmp = stdata[i];
                double sdvar = BartlettApproximation.standardDeviationOfVariance(stmodels[i], itmp.length);
                double evar = AutoCovariances.varianceNoMissing((DoubleSeq)DoubleSeq.of((double[])itmp), (double)0.0) / (err * err);
                double var = stmodels[i].getAutoCovarianceFunction().get(0);
                this.m_tac.set(i, i, var);
                this.m_eac.set(i, i, evar);
                this.m_sdvar.set(i, i, sdvar);
                for (int j = i + 1; j < n; ++j) {
                    double[] jtmp = stdata[j];
                    if (jtmp == null) continue;
                    int ni = itmp.length;
                    int nj = jtmp.length;
                    int si = 0;
                    int sj = 0;
                    int nc = 0;
                    if (ni < nj) {
                        nc = ni;
                        sj = nj - ni;
                    } else {
                        nc = nj;
                        si = ni - nj;
                    }
                    BartlettApproximation.CrossCorrelation cbartlett = new BartlettApproximation.CrossCorrelation(stmodels[i], stmodels[j]);
                    double cov = cbartlett.get(0);
                    double sdcov = cbartlett.standardDeviation(0, nc);
                    DoubleSeq di = DoubleSeq.of((double[])itmp, (int)si, (int)nc);
                    DoubleSeq dj = DoubleSeq.of((double[])jtmp, (int)sj, (int)nc);
                    double vi = AutoCovariances.varianceNoMissing((DoubleSeq)di, (double)0.0);
                    double vj = AutoCovariances.varianceNoMissing((DoubleSeq)dj, (double)0.0);
                    double cvij = AutoCovariances.covarianceWithZeroMean((DoubleSeq)di, (DoubleSeq)dj);
                    double ecov = cvij / Math.sqrt(vi * vj);
                    this.m_tac.set(i, j, cov);
                    this.m_tac.set(j, i, cov);
                    this.m_sdvar.set(i, j, sdcov);
                    this.m_sdvar.set(j, i, sdcov);
                    this.m_eac.set(i, j, ecov);
                    this.m_eac.set(j, i, ecov);
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public double getPValue(int i) {
        if (this.m_stcmp[i] == null) {
            return Double.NaN;
        }
        Normal dist = new Normal();
        double z = Math.abs(this.m_tac.get(i, i) - this.m_eac.get(i, i)) / this.m_sdvar.get(i, i);
        return 1.0 - dist.getProbabilityForInterval(-z, z);
    }

    public double getPValue(int i, int j) {
        if (this.m_stcmp[i] == null || this.m_stcmp[j] == null) {
            return Double.NaN;
        }
        Normal dist = new Normal();
        double z = Math.abs(this.m_tac.get(i, j) - this.m_eac.get(i, j)) / this.m_sdvar.get(i, j);
        return 1.0 - dist.getProbabilityForInterval(-z, z);
    }

    public double getEstimatorVariance(int i) {
        if (this.m_stcmp[i] == null) {
            return Double.NaN;
        }
        return this.m_tac.get(i, i);
    }

    public double getEstimateVariance(int i) {
        if (this.m_stcmp[i] == null) {
            return Double.NaN;
        }
        return this.m_eac.get(i, i);
    }

    public double getEstimatorSDVariance(int i) {
        if (this.m_stcmp[i] == null) {
            return Double.NaN;
        }
        return this.m_sdvar.get(i, i);
    }

    public double getEstimatorCrossCorrelation(int i, int j) {
        if (this.m_stcmp[i] == null || this.m_stcmp[j] == null) {
            return Double.NaN;
        }
        return this.m_tac.get(i, j);
    }

    public double getEstimateCrossCorrelation(int i, int j) {
        if (this.m_stcmp[i] == null || this.m_stcmp[j] == null) {
            return Double.NaN;
        }
        return this.m_eac.get(i, j);
    }

    public double getEstimatorSDCrossCorrelation(int i, int j) {
        if (this.m_stcmp[i] == null || this.m_stcmp[j] == null) {
            return Double.NaN;
        }
        return this.m_sdvar.get(i, j);
    }

    public ArimaModel getStationaryComponentModel(int i) {
        return this.m_stcmp[i];
    }

    public LinearProcess getStationaryEstimatorModel(int i) {
        return this.m_stest[i];
    }

    public DoubleSeq getStationaryEstimate(int i) {
        return this.m_stdata[i] == null ? null : DoubleSeq.of((double[])this.m_stdata[i]);
    }
}

