/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.markovchain;

import java.util.HashMap;
import java.util.Map;

public class Profiler {
    private static boolean profilerAvailable = true;
    private static Map<String, Profile> profiles = new HashMap<String, Profile>();
    private static long startTime;

    public static boolean startProfile() {
        if (profilerAvailable) {
            startTime = Profiler.getCurrentThreadCpuTime();
        }
        return true;
    }

    public static boolean stopProfile(String string) {
        if (profilerAvailable) {
            long l = Profiler.getCurrentThreadCpuTime();
            long l2 = 1L;
            long l3 = l - startTime;
            Profile profile = profiles.get(string);
            if (profile != null) {
                l3 += profile.time;
                l2 += profile.count;
            }
            profiles.put(string, new Profile(l2, l3));
        }
        return true;
    }

    public static void report() {
        if (profilerAvailable) {
            for (String string : profiles.keySet()) {
                Profile profile = profiles.get(string);
                long l = profile.time / profile.count;
                System.err.println("PROFILE: " + string + " [" + profile.time + " ms, " + profile.count + " calls, " + l + " ms / call]");
            }
        }
    }

    public static native long getCurrentThreadCpuTime();

    static {
        try {
            System.loadLibrary("mcmcprof");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            profilerAvailable = false;
        }
    }

    private static class Profile {
        long time;
        long count;

        Profile(long l, long l2) {
            this.count = l;
            this.time = l2;
        }
    }
}

