/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.Timer;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.BenchmarkMatrixKernel;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class BenchmarkDenseDComplexMatrix3D {
    private static Timer t = new Timer();
    private static final String outputFile = "BenchmarkDenseDComplexMatrix3D.txt";
    private static double[][][] a_3d;
    private static double[][][] b_3d;
    private static double[] a_1d;
    private static double[] b_1d;
    private static double[] noViewTimes;
    private static double[] viewTimes;

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{"cern.colt.matrix.tdcomplex.impl.BenchmarkDenseDComplexMatrix3D"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        int n;
        int n2;
        int n3;
        BenchmarkMatrixKernel.readSettings3D();
        Random random = new Random(0L);
        ConcurrencyUtils.setThreadsBeginN_3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        a_1d = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        a_3d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        int n4 = 0;
        for (n3 = 0; n3 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]; ++n3) {
            for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]; ++n2) {
                for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]; ++n) {
                    BenchmarkDenseDComplexMatrix3D.a_3d[n3][n2][n] = random.nextDouble();
                    BenchmarkDenseDComplexMatrix3D.a_1d[n4++] = a_3d[n3][n2][n];
                }
            }
        }
        b_1d = new double[2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[0] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[1] * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        b_3d = new double[BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]][BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]][2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]];
        n4 = 0;
        for (n3 = 0; n3 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]; ++n3) {
            for (n2 = 0; n2 < BenchmarkMatrixKernel.MATRIX_SIZE_3D[1]; ++n2) {
                for (n = 0; n < 2 * BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]; ++n) {
                    BenchmarkDenseDComplexMatrix3D.b_3d[n3][n2][n] = random.nextDouble();
                    BenchmarkDenseDComplexMatrix3D.b_1d[n4++] = b_3d[n3][n2][n];
                }
            }
        }
        BenchmarkMatrixKernel.writePropertiesToFile(outputFile, BenchmarkMatrixKernel.MATRIX_SIZE_3D);
        BenchmarkMatrixKernel.displayProperties(BenchmarkMatrixKernel.MATRIX_SIZE_3D);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        a_1d = null;
        a_3d = null;
        b_1d = null;
        b_3d = null;
        ConcurrencyUtils.resetThreadsBeginN();
        System.gc();
    }

    @Before
    public void setUpBefore() {
        noViewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
        viewTimes = new double[BenchmarkMatrixKernel.NTHREADS.length];
    }

    @Test
    public void testAggregateDComplexDComplexDComplexFunctionDComplexDComplexFunction() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = ((DComplexMatrix3D)denseDComplexMatrix3D).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DComplexMatrix3D)denseDComplexMatrix3D).aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[] dArray = dComplexMatrix3D.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix3D.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DComplexDComplexDComplexFunction, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAggregateDComplexMatrix3DDComplexDComplexDComplexFunctionDComplexDComplexDComplexFunction() {
        int n;
        Object object;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        DenseDComplexMatrix3D denseDComplexMatrix3D2 = new DenseDComplexMatrix3D(b_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            object = ((DComplexMatrix3D)denseDComplexMatrix3D).aggregate(denseDComplexMatrix3D2, DComplexFunctions.plus, DComplexFunctions.mult);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                object = ((DComplexMatrix3D)denseDComplexMatrix3D).aggregate(denseDComplexMatrix3D2, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        object = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(b_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = dComplexMatrix3D.aggregate((DComplexMatrix3D)object, DComplexFunctions.plus, DComplexFunctions.mult);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix3D.aggregate((DComplexMatrix3D)object, DComplexFunctions.plus, DComplexFunctions.mult);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "aggregate(DComplexMatrix3D, DComplexDComplexDComplexFunction, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleDouble() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        double d = Math.random();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix3D)denseDComplexMatrix3D).assign(d, d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(d, d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix3D.assign(d, d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix3D.assign(d, d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double, double)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArray() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix3D)denseDComplexMatrix3D).assign(a_1d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(a_1d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix3D.assign(a_1d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix3D.assign(a_1d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDoubleArrayArrayArray() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix3D)denseDComplexMatrix3D).assign(a_3d);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(a_3d);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix3D.assign(a_3d);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix3D.assign(a_3d);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(double[][][])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexDComplexFunction() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix3D)denseDComplexMatrix3D).assign(DComplexFunctions.acos);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(a_3d);
                t.reset().start();
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(DComplexFunctions.acos);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix3D.assign(DComplexFunctions.acos);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(a_3d);
                t.reset().start();
                dComplexMatrix3D.assign(DComplexFunctions.acos);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix3D() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        DenseDComplexMatrix3D denseDComplexMatrix3D2 = new DenseDComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DComplexMatrix3D)denseDComplexMatrix3D).assign(denseDComplexMatrix3D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(0.0, 0.0);
                t.reset().start();
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(denseDComplexMatrix3D2);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[0], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[2]);
        DComplexMatrix3D dComplexMatrix3D = denseDComplexMatrix3D.viewDice(2, 1, 0);
        denseDComplexMatrix3D2 = new DenseDComplexMatrix3D(a_3d);
        DComplexMatrix3D dComplexMatrix3D2 = denseDComplexMatrix3D2.viewDice(2, 1, 0);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            dComplexMatrix3D.assign(dComplexMatrix3D2);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(0.0, 0.0);
                t.reset().start();
                dComplexMatrix3D.assign(dComplexMatrix3D2);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexMatrix3D)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexMatrix3DDComplexDComplexDComplexFunction() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        DenseDComplexMatrix3D denseDComplexMatrix3D2 = new DenseDComplexMatrix3D(b_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DComplexMatrix3D)denseDComplexMatrix3D).assign(denseDComplexMatrix3D2, DComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(a_3d);
                t.reset().start();
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(denseDComplexMatrix3D2, DComplexFunctions.div);
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        DComplexMatrix3D dComplexMatrix3D2 = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(b_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            dComplexMatrix3D.assign(dComplexMatrix3D2, DComplexFunctions.div);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(a_3d);
                t.reset().start();
                dComplexMatrix3D.assign(dComplexMatrix3D2, DComplexFunctions.div);
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexMatrix3D, DComplexDComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDoubleArray() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        double[] dArray = new double[]{-1.0, -2.0};
        DComplexProcedure dComplexProcedure = new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix3D)denseDComplexMatrix3D).assign(dComplexProcedure, dArray);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(a_3d);
                t.reset().start();
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(dComplexProcedure, dArray);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix3D.assign(dComplexProcedure, dArray);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(a_3d);
                t.reset().start();
                dComplexMatrix3D.assign(dComplexProcedure, dArray);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexProcedure, double[])";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testAssignDComplexProcedureDComplexDComplexFunction() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        DComplexProcedure dComplexProcedure = new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 0.1;
            }
        };
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix3D)denseDComplexMatrix3D).assign(dComplexProcedure, DComplexFunctions.tan);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(a_3d);
                t.reset().start();
                ((DComplexMatrix3D)denseDComplexMatrix3D).assign(dComplexProcedure, DComplexFunctions.tan);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix3D.assign(dComplexProcedure, DComplexFunctions.tan);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(a_3d);
                t.reset().start();
                dComplexMatrix3D.assign(dComplexProcedure, DComplexFunctions.tan);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "assign(DComplexProcedure, DComplexDComplexFunction)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testCardinality() {
        int n;
        int n2;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n3 = 0;
        while (n3 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n3]);
            n2 = ((DComplexMatrix3D)denseDComplexMatrix3D).cardinality();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                t.reset().start();
                n2 = ((DComplexMatrix3D)denseDComplexMatrix3D).cardinality();
                t.stop();
                int n4 = n3;
                noViewTimes[n4] = noViewTimes[n4] + t.millis();
            }
            int n5 = n3++;
            noViewTimes[n5] = noViewTimes[n5] / (double)BenchmarkMatrixKernel.NITERS;
        }
        denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        DComplexMatrix3D dComplexMatrix3D = denseDComplexMatrix3D.viewDice(2, 1, 0);
        n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            n = dComplexMatrix3D.cardinality();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                n = dComplexMatrix3D.cardinality();
                t.stop();
                int n6 = n2;
                viewTimes[n6] = viewTimes[n6] + t.millis();
            }
            int n7 = n2++;
            viewTimes[n7] = viewTimes[n7] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "cardinality()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft3() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix3D.fft3();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix3D.assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D.fft3();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDComplexMatrix3D)dComplexMatrix3D).fft3();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(a_3d);
                t.reset().start();
                ((DenseDComplexMatrix3D)dComplexMatrix3D).fft3();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft3()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testFft2Slices() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix3D.fft2Slices();
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix3D.assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D.fft2Slices();
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDComplexMatrix3D)dComplexMatrix3D).fft2Slices();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(a_3d);
                t.reset().start();
                ((DenseDComplexMatrix3D)dComplexMatrix3D).fft2Slices();
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "fft2Slices()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetRealPart() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            DoubleMatrix3D doubleMatrix3D = ((DComplexMatrix3D)denseDComplexMatrix3D).getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix3D = ((DComplexMatrix3D)denseDComplexMatrix3D).getRealPart();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DoubleMatrix3D doubleMatrix3D = dComplexMatrix3D.getRealPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix3D = dComplexMatrix3D.getRealPart();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getRealPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetImaginaryPart() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            DoubleMatrix3D doubleMatrix3D = ((DComplexMatrix3D)denseDComplexMatrix3D).getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix3D = ((DComplexMatrix3D)denseDComplexMatrix3D).getImaginaryPart();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DoubleMatrix3D doubleMatrix3D = dComplexMatrix3D.getImaginaryPart();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                doubleMatrix3D = dComplexMatrix3D.getImaginaryPart();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getImaginaryPart()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testGetNonZerosIntArrayListIntArrayListIntArrayListArrayList() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            ((DComplexMatrix3D)denseDComplexMatrix3D).getNonZeros(intArrayList, intArrayList2, intArrayList3, arrayList);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                intArrayList.clear();
                intArrayList2.clear();
                intArrayList3.clear();
                arrayList.clear();
                t.reset().start();
                ((DComplexMatrix3D)denseDComplexMatrix3D).getNonZeros(intArrayList, intArrayList2, intArrayList3, arrayList);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(a_3d).viewDice(2, 1, 0);
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        arrayList.clear();
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            dComplexMatrix3D.getNonZeros(intArrayList, intArrayList2, intArrayList3, arrayList);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                intArrayList.clear();
                intArrayList2.clear();
                intArrayList3.clear();
                arrayList.clear();
                t.reset().start();
                dComplexMatrix3D.getNonZeros(intArrayList, intArrayList2, intArrayList3, arrayList);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "getNonZeros(IntArrayList, IntArrayList, IntArrayList, ArrayList)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft3() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix3D.ifft3(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix3D.assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D.ifft3(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDComplexMatrix3D)dComplexMatrix3D).ifft3(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(a_3d);
                t.reset().start();
                ((DenseDComplexMatrix3D)dComplexMatrix3D).ifft3(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft3(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testIfft2Slices() {
        int n;
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n2 = 0;
        while (n2 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n2]);
            denseDComplexMatrix3D.ifft2Slices(true);
            for (n = 0; n < BenchmarkMatrixKernel.NITERS; ++n) {
                denseDComplexMatrix3D.assign(a_3d);
                t.reset().start();
                denseDComplexMatrix3D.ifft2Slices(true);
                t.stop();
                int n3 = n2;
                noViewTimes[n3] = noViewTimes[n3] + t.millis();
            }
            int n4 = n2++;
            noViewTimes[n4] = noViewTimes[n4] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            ((DenseDComplexMatrix3D)dComplexMatrix3D).ifft2Slices(true);
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                dComplexMatrix3D.assign(a_3d);
                t.reset().start();
                ((DenseDComplexMatrix3D)dComplexMatrix3D).ifft2Slices(true);
                t.stop();
                int n5 = n;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "ifft2Slices(boolean)";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testSum() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[] dArray = ((DComplexMatrix3D)denseDComplexMatrix3D).zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DComplexMatrix3D)denseDComplexMatrix3D).zSum();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[] dArray = dComplexMatrix3D.zSum();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix3D.zSum();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "zSum()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testToArray() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            double[][][] dArray = ((DComplexMatrix3D)denseDComplexMatrix3D).toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = ((DComplexMatrix3D)denseDComplexMatrix3D).toArray();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            double[][][] dArray = dComplexMatrix3D.toArray();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dArray = dComplexMatrix3D.toArray();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "toArray()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }

    @Test
    public void testVectorize() {
        DenseDComplexMatrix3D denseDComplexMatrix3D = new DenseDComplexMatrix3D(a_3d);
        int n = 0;
        while (n < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n]);
            DComplexMatrix1D dComplexMatrix1D = ((DComplexMatrix3D)denseDComplexMatrix3D).vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dComplexMatrix1D = ((DComplexMatrix3D)denseDComplexMatrix3D).vectorize();
                t.stop();
                int n2 = n;
                noViewTimes[n2] = noViewTimes[n2] + t.millis();
            }
            int n3 = n++;
            noViewTimes[n3] = noViewTimes[n3] / (double)BenchmarkMatrixKernel.NITERS;
        }
        DComplexMatrix3D dComplexMatrix3D = new DenseDComplexMatrix3D(BenchmarkMatrixKernel.MATRIX_SIZE_3D[2], BenchmarkMatrixKernel.MATRIX_SIZE_3D[1], BenchmarkMatrixKernel.MATRIX_SIZE_3D[0]).viewDice(2, 1, 0).assign(a_3d);
        int n4 = 0;
        while (n4 < BenchmarkMatrixKernel.NTHREADS.length) {
            ConcurrencyUtils.setNumberOfThreads(BenchmarkMatrixKernel.NTHREADS[n4]);
            DComplexMatrix1D dComplexMatrix1D = dComplexMatrix3D.vectorize();
            for (int i = 0; i < BenchmarkMatrixKernel.NITERS; ++i) {
                t.reset().start();
                dComplexMatrix1D = dComplexMatrix3D.vectorize();
                t.stop();
                int n5 = n4;
                viewTimes[n5] = viewTimes[n5] + t.millis();
            }
            int n6 = n4++;
            viewTimes[n6] = viewTimes[n6] / (double)BenchmarkMatrixKernel.NITERS;
        }
        String string = "vectorize()";
        BenchmarkMatrixKernel.writeMatrixBenchmarkResultsToFile(outputFile, string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
        BenchmarkMatrixKernel.displayMatrixBenchmarkResults(string, BenchmarkMatrixKernel.NTHREADS, noViewTimes, viewTimes);
    }
}

