## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include=FALSE-----------------------------------------------------
library(REPS)
data("data_constraxion")

## -----------------------------------------------------------------------------
# Example dataset (you should already have this loaded)
head(data_constraxion)

# We log transform the floor_area again (see vignette on calculating price index as why)
dataset <- data_constraxion
dataset$floor_area <- log(dataset$floor_area)

## -----------------------------------------------------------------------------
diagnostics <- calculate_regression_diagnostics(
  dataset = dataset,
  period_variable = "period",
  dependent_variable = "price",
  numerical_variables = c("floor_area", "dist_trainstation"),
  categorical_variables = c("dummy_large_city", "neighbourhood_code")
)

head(diagnostics)

## ----echo=FALSE, out.width="100%", fig.align="center"-------------------------
knitr::include_graphics("diagnostics_plot.png")

