/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.functions.SMO;
import weka.classifiers.meta.Vote;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Dagging
extends RandomizableSingleClassifierEnhancer
implements TechnicalInformationHandler {
    static final long serialVersionUID = 4560165876570074309L;
    protected int m_NumFolds = 10;
    protected Vote m_Vote = null;
    protected boolean m_Verbose = false;

    public String globalInfo() {
        return "This meta classifier creates a number of disjoint, stratified folds out of the data and feeds each chunk of data to a copy of the supplied base classifier. Predictions are made via majority vote, since all the generated base classifiers are put into the Vote meta classifier. \nUseful for base classifiers that are quadratic or worse in time behavior, regarding number of instances in the training data. \n\nFor more information, see: \n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Ting, K. M. and Witten, I. H.");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Stacking Bagged and Dagged Models");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Fourteenth international Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.EDITOR, "D. H. Fisher");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1997");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "367-375");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann Publishers");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "San Francisco, CA");
        return technicalInformation;
    }

    public Dagging() {
        this.m_Classifier = new SMO();
    }

    protected String defaultClassifierString() {
        return SMO.class.getName();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe number of folds for splitting the training set into\n\tsmaller chunks for the base classifier.\n\t(default 10)", "F", 1, "-F <folds>"));
        vector.addElement(new Option("\tWhether to print some more information during building the\n\tclassifier.\n\t(default is off)", "verbose", 0, "-verbose"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('F', stringArray);
        if (string.length() != 0) {
            this.setNumFolds(Integer.parseInt(string));
        } else {
            this.setNumFolds(10);
        }
        this.setVerbose(Utils.getFlag("verbose", stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-F");
        vector.add("" + this.getNumFolds());
        if (this.getVerbose()) {
            vector.add("-verbose");
        }
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int n) {
        if (n > 0) {
            this.m_NumFolds = n;
        } else {
            System.out.println("At least 1 fold is necessary (provided: " + n + ")!");
        }
    }

    public String numFoldsTipText() {
        return "The number of folds to use for splitting the training set into smaller chunks for the base classifier.";
    }

    public void setVerbose(boolean bl) {
        this.m_Verbose = bl;
    }

    public boolean getVerbose() {
        return this.m_Verbose;
    }

    public String verboseTipText() {
        return "Whether to ouput some additional information during building.";
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Vote = new Vote();
        Classifier[] classifierArray = new Classifier[this.getNumFolds()];
        double d = (double)instances.numInstances() / (double)this.getNumFolds();
        if (this.getNumFolds() > 1) {
            instances.stratify(this.getNumFolds());
        }
        for (int i = 0; i < this.getNumFolds(); ++i) {
            Instances instances2;
            classifierArray[i] = Dagging.makeCopy(this.getClassifier());
            if (this.getNumFolds() > 1) {
                if (this.getVerbose()) {
                    System.out.print(".");
                }
                instances2 = new Instances(instances, 0);
                int n = (int)((double)i * d);
                int n2 = (int)(((double)i + 1.0) * d) - 1;
                if (i == this.getNumFolds() - 1) {
                    n2 = instances.numInstances() - 1;
                }
                for (int j = n; j < n2; ++j) {
                    instances2.add(instances.instance(j));
                }
            } else {
                instances2 = instances;
            }
            classifierArray[i].buildClassifier(instances2);
        }
        this.m_Vote.setClassifiers(classifierArray);
        if (this.getVerbose()) {
            System.out.println();
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_Vote.distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_Vote == null) {
            return this.getClass().getName().replaceAll(".*\\.", "") + ": No model built yet.";
        }
        return this.m_Vote.toString();
    }

    public static void main(String[] stringArray) {
        Dagging.runClassifier(new Dagging(), stringArray);
    }
}

