/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import weka.core.Capabilities;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;

public class SerializedInstancesSaver
extends AbstractFileSaver
implements BatchConverter {
    static final long serialVersionUID = -7717010648500658872L;

    public SerializedInstancesSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Serializes the instances to a file with extension bsi.";
    }

    public String getFileDescription() {
        return "Binary serialized instances";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".bsi");
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void writeBatch() throws IOException {
        this.resetWriter();
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        this.setRetrieval(1);
        if (this.retrieveFile() == null) {
            throw new IOException("No output to standard out for serialization.");
        }
        this.setWriteMode(0);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.retrieveFile())));
        objectOutputStream.writeObject(this.getInstances());
        objectOutputStream.flush();
        objectOutputStream.close();
        this.setWriteMode(1);
        objectOutputStream = null;
        this.resetWriter();
        this.setWriteMode(2);
    }

    public static void main(String[] stringArray) {
        SerializedInstancesSaver.runFileSaver(new SerializedInstancesSaver(), stringArray);
    }
}

