/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import weka.classifiers.bayes.net.GUI;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Copyright;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.SystemInfo;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.Version;
import weka.core.logging.Logger;
import weka.core.scripting.Groovy;
import weka.core.scripting.Jython;
import weka.gui.BrowserHelper;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.LogWindow;
import weka.gui.LookAndFeel;
import weka.gui.MainMenuExtension;
import weka.gui.MemoryUsagePanel;
import weka.gui.SimpleCLIPanel;
import weka.gui.SplashWindow;
import weka.gui.arffviewer.ArffViewerMainPanel;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.StartUpListener;
import weka.gui.boundaryvisualizer.BoundaryVisualizer;
import weka.gui.experiment.Experimenter;
import weka.gui.explorer.Explorer;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.scripting.GroovyPanel;
import weka.gui.scripting.JythonPanel;
import weka.gui.sql.SqlViewer;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class Main
extends JFrame
implements OptionHandler {
    private static final long serialVersionUID = 1453813254824253849L;
    public static final int GUI_MDI = 0;
    public static final int GUI_SDI = 1;
    public static final Tag[] TAGS_GUI = new Tag[]{new Tag(0, "MDI", "MDI Layout"), new Tag(1, "SDI", "SDI Layout")};
    protected Main m_Self;
    protected int m_GUIType = 0;
    protected static Main m_MainCommandline;
    protected static Main m_MainSingleton;
    protected static Vector<StartUpListener> m_StartupListeners;
    protected static Memory m_Memory;
    protected HashSet<Container> m_ChildFrames = new HashSet();
    protected static LogWindow m_LogWindow;
    protected JFileChooser m_FileChooserTreeVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserGraphVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserPlot = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserROC = new JFileChooser(new File(System.getProperty("user.dir")));
    private JMenu jMenuHelp;
    private JMenu jMenuVisualization;
    private JMenu jMenuTools;
    private JDesktopPane jDesktopPane;
    private JMenu jMenuApplications;
    private JMenuItem jMenuItemHelpSystemInfo;
    private JMenuItem jMenuItemHelpAbout;
    private JMenuItem jMenuItemHelpHomepage;
    private JMenuItem jMenuItemHelpWekaWiki;
    private JMenuItem jMenuItemHelpSourceforge;
    private JMenuItem jMenuItemVisualizationBoundaryVisualizer;
    private JMenuItem jMenuItemVisualizationGraphVisualizer;
    private JMenuItem jMenuItemVisualizationTreeVisualizer;
    private JMenuItem jMenuItemVisualizationROC;
    private JMenuItem jMenuItemVisualizationPlot;
    private JMenuItem jMenuItemToolsSqlViewer;
    private JMenuItem jMenuItemToolsGroovyConsole;
    private JMenuItem jMenuItemToolsJythonConsole;
    private JMenuItem jMenuItemToolsArffViewer;
    private JMenuItem jMenuItemApplicationsSimpleCLI;
    private JMenuItem jMenuItemApplicationsKnowledgeFlow;
    private JMenuItem jMenuItemApplicationsExperimenter;
    private JMenuItem jMenuItemApplicationsExplorer;
    private JMenuItem jMenuItemProgramExit;
    private JMenuItem jMenuItemProgramLogWindow;
    private JMenuItem jMenuItemProgramMemoryUsage;
    private JMenu jMenuProgram;
    private JMenu jMenuExtensions;
    private JMenu jMenuWindows;
    private JMenuBar jMenuBar;

    protected Container createFrame(Main parent, String title, Component c, LayoutManager layout, Object layoutConstraints, int width, int height, JMenuBar menu, boolean listener, boolean visible) {
        Container result = null;
        if (this.m_GUIType == 0) {
            final ChildFrameMDI frame = new ChildFrameMDI(parent, title);
            frame.setLayout(layout);
            if (c != null) {
                frame.getContentPane().add(c, layoutConstraints);
            }
            frame.setJMenuBar(menu);
            frame.pack();
            if (width > -1 && height > -1) {
                frame.setSize(width, height);
            }
            frame.validate();
            if (listener) {
                frame.addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosing(InternalFrameEvent e) {
                        frame.dispose();
                    }
                });
            }
            if (visible) {
                frame.setVisible(true);
                try {
                    frame.setSelected(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            result = frame;
        } else if (this.m_GUIType == 1) {
            final ChildFrameSDI frame = new ChildFrameSDI(parent, title);
            frame.setLayout(layout);
            if (c != null) {
                frame.getContentPane().add(c, layoutConstraints);
            }
            frame.setJMenuBar(menu);
            frame.pack();
            if (width > -1 && height > -1) {
                frame.setSize(width, height);
            }
            frame.validate();
            int screenHeight = this.getGraphicsConfiguration().getBounds().height;
            int screenWidth = this.getGraphicsConfiguration().getBounds().width;
            frame.setLocation((screenWidth - frame.getBounds().width) / 2, (screenHeight - frame.getBounds().height) / 2);
            if (listener) {
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        frame.dispose();
                    }
                });
            }
            if (visible) {
                frame.setVisible(true);
            }
            result = frame;
        }
        return result;
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem) {
        this.insertMenuItem(menu, menuitem, 0);
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem, int startIndex) {
        boolean inserted = false;
        String newStr = menuitem.getText().toLowerCase();
        for (int i = startIndex; i < menu.getMenuComponentCount(); ++i) {
            JMenuItem current;
            String currentStr;
            if (!(menu.getMenuComponent(i) instanceof JMenuItem) || (currentStr = (current = (JMenuItem)menu.getMenuComponent(i)).getText().toLowerCase()).compareTo(newStr) <= 0) continue;
            inserted = true;
            menu.insert(menuitem, i);
            break;
        }
        if (!inserted) {
            menu.add(menuitem);
        }
    }

    protected void initGUI() {
        this.m_Self = this;
        try {
            this.createTitle("");
            this.setDefaultCloseOperation(3);
            this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("weka/gui/weka_icon_new_48.png")).getImage());
            this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".bif", "BIF Files (*.bif)"));
            this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".xml", "XML Files (*.xml)"));
            this.m_FileChooserPlot.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
            this.m_FileChooserPlot.setMultiSelectionEnabled(true);
            this.m_FileChooserROC.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
            if (this.m_GUIType == 0) {
                this.jDesktopPane = new BackgroundDesktopPane("weka/gui/images/weka_background.gif");
                this.jDesktopPane.setDragMode(1);
                this.setContentPane(this.jDesktopPane);
            } else {
                this.jDesktopPane = null;
            }
            this.jMenuBar = new JMenuBar();
            this.setJMenuBar(this.jMenuBar);
            this.jMenuProgram = new JMenu();
            this.jMenuBar.add(this.jMenuProgram);
            this.jMenuProgram.setText("Program");
            this.jMenuProgram.setMnemonic('P');
            this.jMenuItemProgramLogWindow = new JMenuItem();
            this.jMenuProgram.add(this.jMenuItemProgramLogWindow);
            this.jMenuItemProgramLogWindow.setText("LogWindow");
            this.jMenuItemProgramLogWindow.setMnemonic('L');
            this.jMenuItemProgramLogWindow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    m_LogWindow.setVisible(true);
                }
            });
            this.jMenuItemProgramMemoryUsage = new JMenuItem();
            this.jMenuProgram.add(this.jMenuItemProgramMemoryUsage);
            this.jMenuItemProgramMemoryUsage.setText("Memory usage");
            this.jMenuItemProgramMemoryUsage.setMnemonic('M');
            this.jMenuItemProgramMemoryUsage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemProgramMemoryUsage.getText();
                    if (!Main.this.containsWindow(title)) {
                        final MemoryUsagePanel panel = new MemoryUsagePanel();
                        Container c = Main.this.createFrame(Main.this.m_Self, title, panel, new BorderLayout(), "Center", 400, 50, null, true, true);
                        Dimension size = c.getPreferredSize();
                        c.setSize(new Dimension((int)size.getWidth(), (int)size.getHeight()));
                        if (Main.this.m_GUIType == 0) {
                            ChildFrameMDI frame = (ChildFrameMDI)c;
                            Point l = panel.getFrameLocation();
                            if (l.x != -1 && l.y != -1) {
                                frame.setLocation(l);
                            }
                            frame.addInternalFrameListener(new InternalFrameAdapter(){

                                @Override
                                public void internalFrameClosing(InternalFrameEvent e) {
                                    panel.stopMonitoring();
                                }
                            });
                        } else {
                            ChildFrameSDI frame = (ChildFrameSDI)c;
                            Point l = panel.getFrameLocation();
                            if (l.x != -1 && l.y != -1) {
                                frame.setLocation(l);
                            }
                            frame.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosing(WindowEvent e) {
                                    panel.stopMonitoring();
                                }
                            });
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuProgram.add(new JSeparator());
            this.jMenuItemProgramExit = new JMenuItem();
            this.jMenuProgram.add(this.jMenuItemProgramExit);
            this.jMenuItemProgramExit.setText("Exit");
            this.jMenuItemProgramExit.setMnemonic('E');
            this.jMenuItemProgramExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Iterator<Container> iter = Main.this.getWindowList();
                    Vector<Container> list = new Vector<Container>();
                    while (iter.hasNext()) {
                        list.add(iter.next());
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        Container c = (Container)list.get(i);
                        if (c instanceof ChildFrameMDI) {
                            ((ChildFrameMDI)c).dispose();
                            continue;
                        }
                        if (!(c instanceof ChildFrameSDI)) continue;
                        ((ChildFrameSDI)c).dispose();
                    }
                    m_LogWindow.dispose();
                    Main.this.m_Self.dispose();
                    System.exit(0);
                }
            });
            this.jMenuApplications = new JMenu();
            this.jMenuBar.add(this.jMenuApplications);
            this.jMenuApplications.setText("Applications");
            this.jMenuApplications.setMnemonic('A');
            this.jMenuItemApplicationsExplorer = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsExplorer);
            this.jMenuItemApplicationsExplorer.setText("Explorer");
            this.jMenuItemApplicationsExplorer.setMnemonic('E');
            this.jMenuItemApplicationsExplorer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemApplicationsExplorer.getText();
                    if (!Main.this.containsWindow(title)) {
                        Main.this.createFrame(Main.this.m_Self, title, new Explorer(), new BorderLayout(), "Center", 800, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuItemApplicationsExperimenter = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsExperimenter);
            this.jMenuItemApplicationsExperimenter.setText("Experimenter");
            this.jMenuItemApplicationsExperimenter.setMnemonic('X');
            this.jMenuItemApplicationsExperimenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemApplicationsExperimenter.getText();
                    if (!Main.this.containsWindow(title)) {
                        Main.this.createFrame(Main.this.m_Self, title, new Experimenter(false), new BorderLayout(), "Center", 800, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuItemApplicationsKnowledgeFlow = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsKnowledgeFlow);
            this.jMenuItemApplicationsKnowledgeFlow.setText("KnowledgeFlow");
            this.jMenuItemApplicationsKnowledgeFlow.setMnemonic('K');
            this.jMenuItemApplicationsKnowledgeFlow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemApplicationsKnowledgeFlow.getText();
                    if (!Main.this.containsWindow(title)) {
                        KnowledgeFlowApp.createSingleton(new String[0]);
                        Main.this.createFrame(Main.this.m_Self, title, KnowledgeFlowApp.getSingleton(), new BorderLayout(), "Center", 900, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuItemApplicationsSimpleCLI = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsSimpleCLI);
            this.jMenuItemApplicationsSimpleCLI.setText("SimpleCLI");
            this.jMenuItemApplicationsSimpleCLI.setMnemonic('S');
            this.jMenuItemApplicationsSimpleCLI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemApplicationsSimpleCLI.getText();
                    if (!Main.this.containsWindow(title)) {
                        try {
                            Main.this.createFrame(Main.this.m_Self, title, new SimpleCLIPanel(), new BorderLayout(), "Center", 600, 500, null, true, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(Main.this.m_Self, "Error instantiating SimpleCLI:\n" + e.getMessage());
                            return;
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuTools = new JMenu();
            this.jMenuBar.add(this.jMenuTools);
            this.jMenuTools.setText("Tools");
            this.jMenuTools.setMnemonic('T');
            this.jMenuItemToolsArffViewer = new JMenuItem();
            this.jMenuTools.add(this.jMenuItemToolsArffViewer);
            this.jMenuItemToolsArffViewer.setText("ArffViewer");
            this.jMenuItemToolsArffViewer.setMnemonic('A');
            this.jMenuItemToolsArffViewer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemToolsArffViewer.getText();
                    if (!Main.this.containsWindow(title)) {
                        ArffViewerMainPanel panel = new ArffViewerMainPanel(null);
                        panel.setConfirmExit(false);
                        Container frame = Main.this.createFrame(Main.this.m_Self, title, panel, new BorderLayout(), "Center", 800, 600, panel.getMenu(), true, true);
                        panel.setParent(frame);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuItemToolsSqlViewer = new JMenuItem();
            this.jMenuTools.add(this.jMenuItemToolsSqlViewer);
            this.jMenuItemToolsSqlViewer.setText("SqlViewer");
            this.jMenuItemToolsSqlViewer.setMnemonic('S');
            this.jMenuItemToolsSqlViewer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemToolsSqlViewer.getText();
                    if (!Main.this.containsWindow(title)) {
                        final SqlViewer sql = new SqlViewer(null);
                        final Container frame = Main.this.createFrame(Main.this.m_Self, title, sql, new BorderLayout(), "Center", -1, -1, null, false, true);
                        if (frame instanceof ChildFrameMDI) {
                            ((ChildFrameMDI)frame).addInternalFrameListener(new InternalFrameAdapter(){

                                @Override
                                public void internalFrameClosing(InternalFrameEvent e) {
                                    sql.saveSize();
                                    ((ChildFrameMDI)frame).dispose();
                                }
                            });
                        } else if (frame instanceof ChildFrameSDI) {
                            ((ChildFrameSDI)frame).addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosing(WindowEvent e) {
                                    sql.saveSize();
                                    ((ChildFrameSDI)frame).dispose();
                                }
                            });
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            final JMenuItem jMenuItemBayesNet = new JMenuItem();
            this.jMenuTools.add(jMenuItemBayesNet);
            jMenuItemBayesNet.setText("Bayes net editor");
            jMenuItemBayesNet.setMnemonic('N');
            jMenuItemBayesNet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String title = jMenuItemBayesNet.getText();
                    if (!Main.this.containsWindow(title)) {
                        GUI bayesNetGUI = new GUI();
                        Main.this.createFrame(Main.this.m_Self, title, bayesNetGUI, new BorderLayout(), "Center", 800, 600, bayesNetGUI.getMenuBar(), false, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            if (Groovy.isPresent()) {
                this.jMenuItemToolsGroovyConsole = new JMenuItem();
                this.jMenuTools.add(this.jMenuItemToolsGroovyConsole);
                this.jMenuItemToolsGroovyConsole.setText("Groovy console");
                this.jMenuItemToolsGroovyConsole.setMnemonic('G');
                this.jMenuItemToolsGroovyConsole.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        String title = Main.this.jMenuItemToolsGroovyConsole.getText();
                        if (!Main.this.containsWindow(title)) {
                            GroovyPanel panel = new GroovyPanel();
                            final Container frame = Main.this.createFrame(Main.this.m_Self, title, panel, new BorderLayout(), "Center", 800, 600, panel.getMenuBar(), false, true);
                            if (frame instanceof ChildFrameMDI) {
                                ((ChildFrameMDI)frame).addInternalFrameListener(new InternalFrameAdapter(){

                                    @Override
                                    public void internalFrameClosing(InternalFrameEvent e) {
                                        ((ChildFrameMDI)frame).dispose();
                                    }
                                });
                            } else if (frame instanceof ChildFrameSDI) {
                                ((ChildFrameSDI)frame).addWindowListener(new WindowAdapter(){

                                    @Override
                                    public void windowClosing(WindowEvent e) {
                                        ((ChildFrameSDI)frame).dispose();
                                    }
                                });
                            }
                        } else {
                            Main.this.showWindow(Main.this.getWindow(title));
                        }
                    }
                });
            }
            if (Jython.isPresent()) {
                this.jMenuItemToolsJythonConsole = new JMenuItem();
                this.jMenuTools.add(this.jMenuItemToolsJythonConsole);
                this.jMenuItemToolsJythonConsole.setText("Jython console");
                this.jMenuItemToolsJythonConsole.setMnemonic('J');
                this.jMenuItemToolsJythonConsole.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        String title = Main.this.jMenuItemToolsJythonConsole.getText();
                        if (!Main.this.containsWindow(title)) {
                            JythonPanel panel = new JythonPanel();
                            final Container frame = Main.this.createFrame(Main.this.m_Self, title, panel, new BorderLayout(), "Center", 800, 600, panel.getMenuBar(), false, true);
                            if (frame instanceof ChildFrameMDI) {
                                ((ChildFrameMDI)frame).addInternalFrameListener(new InternalFrameAdapter(){

                                    @Override
                                    public void internalFrameClosing(InternalFrameEvent e) {
                                        ((ChildFrameMDI)frame).dispose();
                                    }
                                });
                            } else if (frame instanceof ChildFrameSDI) {
                                ((ChildFrameSDI)frame).addWindowListener(new WindowAdapter(){

                                    @Override
                                    public void windowClosing(WindowEvent e) {
                                        ((ChildFrameSDI)frame).dispose();
                                    }
                                });
                            }
                        } else {
                            Main.this.showWindow(Main.this.getWindow(title));
                        }
                    }
                });
            }
            this.jMenuVisualization = new JMenu();
            this.jMenuBar.add(this.jMenuVisualization);
            this.jMenuVisualization.setText("Visualization");
            this.jMenuVisualization.setMnemonic('V');
            this.jMenuItemVisualizationPlot = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationPlot);
            this.jMenuItemVisualizationPlot.setText("Plot");
            this.jMenuItemVisualizationPlot.setMnemonic('P');
            this.jMenuItemVisualizationPlot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int retVal = Main.this.m_FileChooserPlot.showOpenDialog(Main.this.m_Self);
                    if (retVal != 0) {
                        return;
                    }
                    VisualizePanel panel = new VisualizePanel();
                    String filenames = "";
                    File[] files = Main.this.m_FileChooserPlot.getSelectedFiles();
                    for (int j = 0; j < files.length; ++j) {
                        String filename = files[j].getAbsolutePath();
                        if (j > 0) {
                            filenames = filenames + ", ";
                        }
                        filenames = filenames + filename;
                        System.err.println("Loading instances from " + filename);
                        try {
                            BufferedReader r = new BufferedReader(new FileReader(filename));
                            Instances i = new Instances(r);
                            i.setClassIndex(i.numAttributes() - 1);
                            PlotData2D pd1 = new PlotData2D(i);
                            if (j == 0) {
                                pd1.setPlotName("Master plot");
                                panel.setMasterPlot(pd1);
                                continue;
                            }
                            pd1.setPlotName("Plot " + (j + 1));
                            pd1.m_useCustomColour = true;
                            pd1.m_customColour = j % 2 == 0 ? Color.red : Color.blue;
                            panel.addPlot(pd1);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + files[j] + "':\n" + e.getMessage());
                            return;
                        }
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationPlot.getText() + " - " + filenames, panel, new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationROC = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationROC);
            this.jMenuItemVisualizationROC.setText("ROC");
            this.jMenuItemVisualizationROC.setMnemonic('R');
            this.jMenuItemVisualizationROC.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int retVal = Main.this.m_FileChooserROC.showOpenDialog(Main.this.m_Self);
                    if (retVal != 0) {
                        return;
                    }
                    String filename = Main.this.m_FileChooserROC.getSelectedFile().getAbsolutePath();
                    Instances result = null;
                    try {
                        result = new Instances(new BufferedReader(new FileReader(filename)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + filename + "':\n" + e.getMessage());
                        return;
                    }
                    result.setClassIndex(result.numAttributes() - 1);
                    ThresholdVisualizePanel vmc = new ThresholdVisualizePanel();
                    vmc.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(result), 4) + ")");
                    vmc.setName(result.relationName());
                    PlotData2D tempd = new PlotData2D(result);
                    tempd.setPlotName(result.relationName());
                    tempd.addInstanceNumberAttribute();
                    try {
                        vmc.addPlot(tempd);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error adding plot:\n" + e.getMessage());
                        return;
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationROC.getText() + " - " + filename, vmc, new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationTreeVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationTreeVisualizer);
            this.jMenuItemVisualizationTreeVisualizer.setText("TreeVisualizer");
            this.jMenuItemVisualizationTreeVisualizer.setMnemonic('T');
            this.jMenuItemVisualizationTreeVisualizer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int retVal = Main.this.m_FileChooserTreeVisualizer.showOpenDialog(Main.this.m_Self);
                    if (retVal != 0) {
                        return;
                    }
                    String filename = Main.this.m_FileChooserTreeVisualizer.getSelectedFile().getAbsolutePath();
                    TreeBuild builder = new TreeBuild();
                    Node top = null;
                    PlaceNode2 arrange = new PlaceNode2();
                    try {
                        top = builder.create(new FileReader(filename));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + filename + "':\n" + e.getMessage());
                        return;
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationTreeVisualizer.getText() + " - " + filename, new TreeVisualizer(null, top, (NodePlace)arrange), new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationGraphVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationGraphVisualizer);
            this.jMenuItemVisualizationGraphVisualizer.setText("GraphVisualizer");
            this.jMenuItemVisualizationGraphVisualizer.setMnemonic('G');
            this.jMenuItemVisualizationGraphVisualizer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int retVal = Main.this.m_FileChooserGraphVisualizer.showOpenDialog(Main.this.m_Self);
                    if (retVal != 0) {
                        return;
                    }
                    String filename = Main.this.m_FileChooserGraphVisualizer.getSelectedFile().getAbsolutePath();
                    GraphVisualizer panel = new GraphVisualizer();
                    try {
                        if (filename.toLowerCase().endsWith(".xml") || filename.toLowerCase().endsWith(".bif")) {
                            panel.readBIF(new FileInputStream(filename));
                        } else {
                            panel.readDOT(new FileReader(filename));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + filename + "':\n" + e.getMessage());
                        return;
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationGraphVisualizer.getText() + " - " + filename, panel, new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationBoundaryVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationBoundaryVisualizer);
            this.jMenuItemVisualizationBoundaryVisualizer.setText("BoundaryVisualizer");
            this.jMenuItemVisualizationBoundaryVisualizer.setMnemonic('B');
            this.jMenuItemVisualizationBoundaryVisualizer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemVisualizationBoundaryVisualizer.getText();
                    if (!Main.this.containsWindow(title)) {
                        Main.this.createFrame(Main.this.m_Self, title, new BoundaryVisualizer(), new BorderLayout(), "Center", 800, 600, null, true, true);
                        BoundaryVisualizer.setExitIfNoWindowsOpen(false);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuExtensions = new JMenu("Extensions");
            this.jMenuExtensions.setMnemonic(69);
            this.jMenuBar.add(this.jMenuExtensions);
            this.jMenuExtensions.setVisible(false);
            String extensions = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "");
            if (extensions.length() > 0) {
                this.jMenuExtensions.setVisible(true);
                String[] classnames = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "").split(",");
                Hashtable<String, JMenu> submenus = new Hashtable<String, JMenu>();
                for (String classname : classnames) {
                    try {
                        MainMenuExtension ext = (MainMenuExtension)Class.forName(classname).newInstance();
                        JMenu submenu = null;
                        if (ext.getSubmenuTitle() != null && (submenu = (JMenu)submenus.get(ext.getSubmenuTitle())) == null) {
                            submenu = new JMenu(ext.getSubmenuTitle());
                            submenus.put(ext.getSubmenuTitle(), submenu);
                            this.insertMenuItem(this.jMenuExtensions, submenu);
                        }
                        JMenuItem menuitem = new JMenuItem();
                        menuitem.setText(ext.getMenuTitle());
                        ActionListener listener = ext.getActionListener(this.m_Self);
                        if (listener != null) {
                            menuitem.addActionListener(listener);
                        } else {
                            final JMenuItem finalMenuitem = menuitem;
                            final MainMenuExtension finalExt = ext;
                            menuitem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Container frame = Main.this.createFrame(Main.this.m_Self, finalMenuitem.getText(), null, null, null, -1, -1, null, false, false);
                                    finalExt.fillFrame(frame);
                                    frame.setVisible(true);
                                }
                            });
                        }
                        if (submenu != null) {
                            this.insertMenuItem(submenu, menuitem);
                            continue;
                        }
                        this.insertMenuItem(this.jMenuExtensions, menuitem);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.jMenuWindows = new JMenu("Windows");
            this.jMenuWindows.setMnemonic(87);
            this.jMenuBar.add(this.jMenuWindows);
            this.jMenuWindows.setVisible(false);
            this.jMenuHelp = new JMenu();
            this.jMenuBar.add(this.jMenuHelp);
            this.jMenuHelp.setText("Help");
            this.jMenuHelp.setMnemonic('H');
            this.jMenuItemHelpHomepage = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpHomepage);
            this.jMenuItemHelpHomepage.setText("Weka homepage");
            this.jMenuItemHelpHomepage.setMnemonic('H');
            this.jMenuItemHelpHomepage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BrowserHelper.openURL(Main.this.m_Self, "http://www.cs.waikato.ac.nz/~ml/weka/");
                }
            });
            this.jMenuHelp.add(new JSeparator());
            this.jMenuItemHelpWekaWiki = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpWekaWiki);
            this.jMenuItemHelpWekaWiki.setText("HOWTOs, code snippets, etc.");
            this.jMenuItemHelpWekaWiki.setMnemonic('W');
            this.jMenuItemHelpWekaWiki.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BrowserHelper.openURL(Main.this.m_Self, "http://weka.wikispaces.com/");
                }
            });
            this.jMenuItemHelpSourceforge = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpSourceforge);
            this.jMenuItemHelpSourceforge.setText("Weka on SourceForge");
            this.jMenuItemHelpSourceforge.setMnemonic('F');
            this.jMenuItemHelpSourceforge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BrowserHelper.openURL(Main.this.m_Self, "http://sourceforge.net/projects/weka/");
                }
            });
            this.jMenuHelp.add(new JSeparator());
            this.jMenuItemHelpSystemInfo = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpSystemInfo);
            this.jMenuItemHelpSystemInfo.setText("SystemInfo");
            this.jMenuItemHelpHomepage.setMnemonic('S');
            this.jMenuItemHelpSystemInfo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemHelpSystemInfo.getText();
                    if (!Main.this.containsWindow(title)) {
                        Hashtable<String, String> info = new SystemInfo().getSystemInfo();
                        Vector<String> names = new Vector<String>();
                        Enumeration<String> enm = info.keys();
                        while (enm.hasMoreElements()) {
                            names.add(enm.nextElement());
                        }
                        Collections.sort(names);
                        Object[][] data = new String[info.size()][2];
                        for (int i = 0; i < names.size(); ++i) {
                            data[i][0] = ((String)names.get(i)).toString();
                            data[i][1] = info.get(data[i][0]).toString();
                        }
                        Object[] titles = new String[]{"Key", "Value"};
                        JTable table = new JTable(data, titles);
                        Main.this.createFrame(Main.this.m_Self, title, new JScrollPane(table), new BorderLayout(), "Center", 800, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            this.jMenuHelp.add(new JSeparator());
            this.jMenuItemHelpAbout = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpAbout);
            this.jMenuItemHelpAbout.setText("About");
            this.jMenuItemHelpAbout.setMnemonic('A');
            this.jMenuItemHelpAbout.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String title = Main.this.jMenuItemHelpAbout.getText();
                    if (!Main.this.containsWindow(title)) {
                        JPanel wekaPan = new JPanel();
                        wekaPan.setToolTipText("Weka, a native bird of New Zealand");
                        ImageIcon wii = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka3.gif")));
                        JLabel wekaLab = new JLabel(wii);
                        wekaPan.add(wekaLab);
                        Container frame = Main.this.createFrame(Main.this.m_Self, title, wekaPan, new BorderLayout(), "Center", -1, -1, null, true, true);
                        JPanel titlePan = new JPanel();
                        titlePan.setLayout(new GridLayout(8, 1));
                        titlePan.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
                        titlePan.add(new JLabel("Waikato Environment for", 0));
                        titlePan.add(new JLabel("Knowledge Analysis", 0));
                        titlePan.add(new JLabel(""));
                        titlePan.add(new JLabel("Version " + Version.VERSION, 0));
                        titlePan.add(new JLabel(""));
                        titlePan.add(new JLabel("(c) " + Copyright.getFromYear() + " - " + Copyright.getToYear(), 0));
                        titlePan.add(new JLabel(Copyright.getOwner(), 0));
                        titlePan.add(new JLabel(Copyright.getAddress(), 0));
                        if (frame instanceof ChildFrameMDI) {
                            ((ChildFrameMDI)frame).getContentPane().add((Component)titlePan, "North");
                            ((ChildFrameMDI)frame).pack();
                        } else if (frame instanceof ChildFrameSDI) {
                            ((ChildFrameSDI)frame).getContentPane().add((Component)titlePan, "North");
                            ((ChildFrameSDI)frame).pack();
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(title));
                    }
                }
            });
            int screenHeight = this.getGraphicsConfiguration().getBounds().height;
            int screenWidth = this.getGraphicsConfiguration().getBounds().width;
            if (this.m_GUIType == 0) {
                int newHeight = (int)((double)screenHeight * 0.75);
                int newWidth = (int)((double)screenWidth * 0.75);
                this.setSize(1000 > newWidth ? newWidth : 1000, 800 > newHeight ? newHeight : 800);
                this.setLocation((screenWidth - this.getBounds().width) / 2, (screenHeight - this.getBounds().height) / 2);
            } else if (this.m_GUIType == 1) {
                this.pack();
                this.setSize(screenWidth, this.getHeight());
                this.setLocation(0, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createTitle(String title) {
        String newTitle = "Weka " + new Version();
        if (title.length() != 0) {
            newTitle = newTitle + " - " + title;
        }
        this.setTitle(newTitle);
    }

    public void addChildFrame(Container c) {
        this.m_ChildFrames.add(c);
        this.windowListChanged();
    }

    public boolean removeChildFrame(Container c) {
        boolean result = this.m_ChildFrames.remove(c);
        this.windowListChanged();
        return result;
    }

    public boolean showWindow(Container c) {
        boolean result;
        if (c != null) {
            try {
                if (c instanceof ChildFrameMDI) {
                    ChildFrameMDI mdiFrame = (ChildFrameMDI)c;
                    mdiFrame.setIcon(false);
                    mdiFrame.toFront();
                    this.createTitle(mdiFrame.getTitle());
                } else if (c instanceof ChildFrameSDI) {
                    ChildFrameSDI sdiFrame = (ChildFrameSDI)c;
                    sdiFrame.setExtendedState(0);
                    sdiFrame.toFront();
                    this.createTitle(sdiFrame.getTitle());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public boolean showWindow(Class<?> windowClass) {
        return this.showWindow(this.getWindow(windowClass));
    }

    public Iterator<Container> getWindowList() {
        return this.m_ChildFrames.iterator();
    }

    public Container getWindow(Class<?> windowClass) {
        Container result = null;
        Iterator<Container> iter = this.getWindowList();
        while (iter.hasNext()) {
            Container current = iter.next();
            if (current.getClass() != windowClass) continue;
            result = current;
            break;
        }
        return result;
    }

    public Container getWindow(String title) {
        Container result = null;
        Iterator<Container> iter = this.getWindowList();
        while (iter.hasNext()) {
            Container current = iter.next();
            boolean found = false;
            if (current instanceof ChildFrameMDI) {
                found = ((ChildFrameMDI)current).getTitle().equals(title);
            } else if (current instanceof ChildFrameSDI) {
                found = ((ChildFrameSDI)current).getTitle().equals(title);
            }
            if (!found) continue;
            result = current;
            break;
        }
        return result;
    }

    public boolean containsWindow(Class<?> windowClass) {
        return this.getWindow(windowClass) != null;
    }

    public boolean containsWindow(String title) {
        return this.getWindow(title) != null;
    }

    public void minimizeWindows() {
        Iterator<Container> iter = this.getWindowList();
        while (iter.hasNext()) {
            Container frame = iter.next();
            try {
                if (frame instanceof ChildFrameMDI) {
                    ((ChildFrameMDI)frame).setIcon(true);
                    continue;
                }
                if (!(frame instanceof ChildFrameSDI)) continue;
                ((ChildFrameSDI)frame).setExtendedState(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void restoreWindows() {
        Iterator<Container> iter = this.getWindowList();
        while (iter.hasNext()) {
            Container frame = iter.next();
            try {
                if (frame instanceof ChildFrameMDI) {
                    ((ChildFrameMDI)frame).setIcon(false);
                    continue;
                }
                if (!(frame instanceof ChildFrameSDI)) continue;
                ((ChildFrameSDI)frame).setExtendedState(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void windowListChanged() {
        this.createWindowMenu();
    }

    protected synchronized void createWindowMenu() {
        this.jMenuWindows.removeAll();
        JMenuItem menuItem = new JMenuItem("Minimize");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.minimizeWindows();
            }
        });
        this.jMenuWindows.add(menuItem);
        menuItem = new JMenuItem("Restore");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.restoreWindows();
            }
        });
        this.jMenuWindows.add(menuItem);
        this.jMenuWindows.addSeparator();
        int startIndex = this.jMenuWindows.getMenuComponentCount() - 1;
        Iterator<Container> iter = this.getWindowList();
        this.jMenuWindows.setVisible(iter.hasNext());
        while (iter.hasNext()) {
            Container frame = iter.next();
            if (frame instanceof ChildFrameMDI) {
                menuItem = new JMenuItem(((ChildFrameMDI)frame).getTitle());
            } else if (frame instanceof ChildFrameSDI) {
                menuItem = new JMenuItem(((ChildFrameSDI)frame).getTitle());
            }
            this.insertMenuItem(this.jMenuWindows, menuItem, startIndex);
            menuItem.setActionCommand(Integer.toString(frame.hashCode()));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Container frame = null;
                    Iterator<Container> iter = Main.this.getWindowList();
                    while (iter.hasNext()) {
                        frame = iter.next();
                        String hashFrame = Integer.toString(frame.hashCode());
                        if (!hashFrame.equals(evt.getActionCommand())) continue;
                        Main.this.showWindow(frame);
                        break;
                    }
                    Main.this.showWindow(frame);
                }
            });
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.paint(this.getGraphics());
        }
    }

    public static void createSingleton(String[] args) {
        if (m_MainSingleton == null) {
            m_MainSingleton = new Main();
        }
        try {
            m_MainSingleton.setOptions(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < m_StartupListeners.size(); ++i) {
            m_StartupListeners.elementAt(i).startUpComplete();
        }
    }

    public static Main getSingleton() {
        return m_MainSingleton;
    }

    public static void addStartupListener(StartUpListener s) {
        m_StartupListeners.add(s);
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        String desc = "";
        for (int i = 0; i < TAGS_GUI.length; ++i) {
            SelectedTag tag = new SelectedTag(TAGS_GUI[i].getID(), TAGS_GUI);
            desc = desc + "\t" + tag.getSelectedTag().getIDStr() + " = " + tag.getSelectedTag().getReadable() + "\n";
        }
        result.addElement(new Option("\tDetermines the layout of the GUI:\n" + desc + "\t(default: " + new SelectedTag(0, TAGS_GUI) + ")", "gui", 1, "-gui " + Tag.toOptionList(TAGS_GUI)));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-gui");
        result.add("" + this.getGUIType());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("gui", options);
        if (tmpStr.length() != 0) {
            this.setGUIType(new SelectedTag(tmpStr, TAGS_GUI));
        } else {
            this.setGUIType(new SelectedTag(0, TAGS_GUI));
        }
    }

    public void setGUIType(SelectedTag value) {
        if (value.getTags() == TAGS_GUI) {
            this.m_GUIType = value.getSelectedTag().getID();
            this.initGUI();
        }
    }

    public SelectedTag getGUIType() {
        return new SelectedTag(this.m_GUIType, TAGS_GUI);
    }

    public static void main(String[] args) {
        Logger.log(Logger.Level.INFO, "Logging started");
        LookAndFeel.setLookAndFeel();
        try {
            if (Utils.getFlag('h', args)) {
                System.out.println();
                System.out.println("Help requested.");
                System.out.println();
                System.out.println("General options:");
                System.out.println();
                System.out.println("-h");
                System.out.println("\tprints this help screen");
                System.out.println();
                Enumeration<Option> enu = new Main().listOptions();
                while (enu.hasMoreElements()) {
                    Option option = enu.nextElement();
                    System.out.println(option.synopsis());
                    System.out.println(option.description());
                }
                System.out.println();
                System.exit(0);
            }
            Main.addStartupListener(new StartUpListener(){

                @Override
                public void startUpComplete() {
                    m_MainCommandline = Main.getSingleton();
                    m_MainCommandline.setVisible(true);
                }
            });
            Main.addStartupListener(new StartUpListener(){

                @Override
                public void startUpComplete() {
                    SplashWindow.disposeSplash();
                }
            });
            SplashWindow.splash(ClassLoader.getSystemResource("weka/gui/images/weka_splash.gif"));
            final String[] options = (String[])args.clone();
            Thread nt = new Thread(){

                @Override
                public void run() {
                    SplashWindow.invokeMethod(Main.class.getName(), "createSingleton", options);
                }
            };
            nt.start();
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (!m_Memory.isOutOfMemory()) {
                            continue;
                        }
                        m_MainCommandline = null;
                        System.gc();
                        System.err.println("\ndisplayed message:");
                        m_Memory.showOutOfMemory();
                        System.err.println("\nexiting");
                        System.exit(-1);
                    }
                }
            };
            memMonitor.setPriority(10);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        m_StartupListeners = new Vector();
        m_Memory = new Memory(true);
        m_LogWindow = new LogWindow();
    }

    public static class ChildFrameMDI
    extends JInternalFrame {
        private static final long serialVersionUID = 3772573515346899959L;
        protected Main m_Parent;

        public ChildFrameMDI(Main parent, String title) {
            super(title, true, true, true, true);
            this.m_Parent = parent;
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameActivated(InternalFrameEvent e) {
                    if (this.getParentFrame() != null) {
                        this.getParentFrame().createTitle(this.getTitle());
                    }
                }
            });
            if (this.getParentFrame() != null) {
                this.getParentFrame().addChildFrame(this);
                this.getParentFrame().jDesktopPane.add(this);
            }
        }

        public Main getParentFrame() {
            return this.m_Parent;
        }

        @Override
        public void dispose() {
            if (this.getParentFrame() != null) {
                this.getParentFrame().removeChildFrame(this);
                this.getParentFrame().createTitle("");
            }
            super.dispose();
        }
    }

    public static class ChildFrameSDI
    extends JFrame {
        private static final long serialVersionUID = 8588293938686425618L;
        protected Main m_Parent;

        public ChildFrameSDI(Main parent, String title) {
            super(title);
            this.m_Parent = parent;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (this.getParentFrame() != null) {
                        this.getParentFrame().createTitle(this.getTitle());
                    }
                }
            });
            if (this.getParentFrame() != null) {
                this.getParentFrame().addChildFrame(this);
                this.setIconImage(this.getParentFrame().getIconImage());
            }
        }

        public Main getParentFrame() {
            return this.m_Parent;
        }

        @Override
        public void dispose() {
            if (this.getParentFrame() != null) {
                this.getParentFrame().removeChildFrame(this);
                this.getParentFrame().createTitle("");
            }
            super.dispose();
        }
    }

    public static class BackgroundDesktopPane
    extends JDesktopPane {
        private static final long serialVersionUID = 2046713123452402745L;
        protected Image m_Background;

        public BackgroundDesktopPane(String image) {
            try {
                this.m_Background = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(image));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.m_Background != null) {
                g.setColor(Color.WHITE);
                g.clearRect(0, 0, this.getWidth(), this.getHeight());
                int width = this.m_Background.getWidth(null);
                int height = this.m_Background.getHeight(null);
                int x = (this.getWidth() - width) / 2;
                int y = (this.getHeight() - height) / 2;
                g.drawImage(this.m_Background, x, y, width, height, this);
            }
        }
    }
}

