// Boost.Geometry (aka GGL, Generic Geometry Library)

// Copyright (c) 2007-2012 Barend Gehrels, Amsterdam, the Netherlands.
// Copyright (c) 2008-2012 Bruno Lalande, Paris, France.
// Copyright (c) 2009-2012 Mateusz Loskot, London, UK.

// This file was modified by Oracle on 2020-2021.
// Modifications copyright (c) 2020-2021, Oracle and/or its affiliates.
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Parts of Boost.Geometry are redesigned from Geodan's Geographic Library
// (geolib/GGL), copyright (c) 1995-2010 Geodan, Amsterdam, the Netherlands.

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_GEOMETRY_GEOMETRIES_HPP
#define BOOST_GEOMETRY_GEOMETRIES_HPP

#include <b/geometry/geometries/box.hpp>
#include <b/geometry/geometries/geometry_collection.hpp>
#include <b/geometry/geometries/linestring.hpp>
#include <b/geometry/geometries/multi_linestring.hpp>
#include <b/geometry/geometries/multi_point.hpp>
#include <b/geometry/geometries/multi_polygon.hpp>
#include <b/geometry/geometries/point.hpp>
#include <b/geometry/geometries/point_xy.hpp>
#include <b/geometry/geometries/point_xyz.hpp>
#include <b/geometry/geometries/polygon.hpp>
#include <b/geometry/geometries/ring.hpp>
#include <b/geometry/geometries/segment.hpp>

#endif // BOOST_GEOMETRY_GEOMETRIES_HPP
