## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include = FALSE---------------------------------------------------
library(rbranding)

## -----------------------------------------------------------------------------
# Temp directory
tmpdir <- file.path(tempdir(), "rbranding_example")
# Initializes the brand files in the current working directory
brand_init(install_path = tmpdir)

cat(readLines(file.path(tmpdir, "_brand.yml")), sep = "\n")

# Downloads the public brand file from the rbranding GitHub page
# and saves it as _brand.yml in the current working directory
get_brand_public(
  config_file = file.path(tmpdir, "rbranding_config.yml"),
  run_interactive = FALSE
)

# Check the contents of the _brand.yml file
cat(readLines(file.path(tmpdir, "_brand.yml")), sep = "\n")

## ----cleanup, include = FALSE-------------------------------------------------
unlink(tmpdir, recursive = TRUE)

