/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.modelling.regular;

import jdplus.toolkit.base.api.timeseries.TimeSelector;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class EstimateSpec {
    public static final double DEF_EPS = 1.0E-7;
    public static final double DEF_IEPS = 1.0E-4;
    @NonNull
    private final TimeSelector span;
    private final double precision;
    private final double intermediatePrecision;
    public static final EstimateSpec DEFAULT = EstimateSpec.builder().build();

    public static Builder builder() {
        return new Builder().span(TimeSelector.all()).precision(1.0E-7).intermediatePrecision(1.0E-4);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    @Generated
    EstimateSpec(@NonNull TimeSelector span, double precision, double intermediatePrecision) {
        if (span == null) {
            throw new NullPointerException("span is marked non-null but is null");
        }
        this.span = span;
        this.precision = precision;
        this.intermediatePrecision = intermediatePrecision;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().span(this.span).precision(this.precision).intermediatePrecision(this.intermediatePrecision);
    }

    @NonNull
    @Generated
    public TimeSelector getSpan() {
        return this.span;
    }

    @Generated
    public double getPrecision() {
        return this.precision;
    }

    @Generated
    public double getIntermediatePrecision() {
        return this.intermediatePrecision;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EstimateSpec)) {
            return false;
        }
        EstimateSpec other = (EstimateSpec)o;
        if (Double.compare(this.getPrecision(), other.getPrecision()) != 0) {
            return false;
        }
        if (Double.compare(this.getIntermediatePrecision(), other.getIntermediatePrecision()) != 0) {
            return false;
        }
        TimeSelector this$span = this.getSpan();
        TimeSelector other$span = other.getSpan();
        return !(this$span == null ? other$span != null : !((Object)this$span).equals(other$span));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $precision = Double.doubleToLongBits(this.getPrecision());
        result = result * 59 + (int)($precision >>> 32 ^ $precision);
        long $intermediatePrecision = Double.doubleToLongBits(this.getIntermediatePrecision());
        result = result * 59 + (int)($intermediatePrecision >>> 32 ^ $intermediatePrecision);
        TimeSelector $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : ((Object)$span).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "EstimateSpec(span=" + String.valueOf(this.getSpan()) + ", precision=" + this.getPrecision() + ", intermediatePrecision=" + this.getIntermediatePrecision() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private TimeSelector span;
        @Generated
        private double precision;
        @Generated
        private double intermediatePrecision;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder span(@NonNull TimeSelector span) {
            if (span == null) {
                throw new NullPointerException("span is marked non-null but is null");
            }
            this.span = span;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder precision(double precision) {
            this.precision = precision;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder intermediatePrecision(double intermediatePrecision) {
            this.intermediatePrecision = intermediatePrecision;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull EstimateSpec build() {
            return new EstimateSpec(this.span, this.precision, this.intermediatePrecision);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "EstimateSpec.Builder(span=" + String.valueOf(this.span) + ", precision=" + this.precision + ", intermediatePrecision=" + this.intermediatePrecision + ")";
        }
    }
}

