/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jdplus.toolkit.base.api.timeseries.Day;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class Days
implements TimeSeriesDomain<Day> {
    @NonNull
    private final LocalDate[] days;

    @Override
    public int length() {
        return this.days.length;
    }

    @Override
    public Day get(int index) throws IndexOutOfBoundsException {
        return Day.of(this.days[index]);
    }

    @Override
    public LocalDateTime start() {
        return this.days[0].atStartOfDay();
    }

    @Override
    public LocalDateTime end() {
        return this.days[this.days.length - 1].plusDays(1L).atStartOfDay();
    }

    @Override
    public boolean contains(LocalDateTime date) {
        LocalDate day = date.toLocalDate();
        return Arrays.binarySearch(this.days, day) >= 0;
    }

    @Override
    public int indexOf(LocalDateTime date) {
        LocalDate day = date.toLocalDate();
        return Arrays.binarySearch(this.days, day);
    }

    public static Days of(List<LocalDate> values) {
        return Days.of(values.toArray(new LocalDate[values.size()]));
    }

    @Override
    public int indexOf(Day point) {
        return Arrays.binarySearch(this.days, point.getDay());
    }

    @Override
    public boolean contains(Day period) {
        return Arrays.binarySearch(this.days, period.getDay()) >= 0;
    }

    @Override
    public Iterator<Day> iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TimeSeriesDomain<Day> select(TimeSelector selector) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Generated
    private Days(@NonNull LocalDate[] days) {
        if (days == null) {
            throw new NullPointerException("days is marked non-null but is null");
        }
        this.days = days;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Days of(@NonNull LocalDate[] days) {
        if (days == null) {
            throw new NullPointerException("days is marked non-null but is null");
        }
        return new Days(days);
    }

    @NonNull
    @Generated
    public LocalDate[] getDays() {
        return this.days;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Days)) {
            return false;
        }
        Days other = (Days)o;
        return Arrays.deepEquals(this.getDays(), other.getDays());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getDays());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "Days(days=" + Arrays.deepToString(this.getDays()) + ")";
    }
}

