/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import jdplus.toolkit.base.api.time.ISO_8601;
import jdplus.toolkit.base.api.time.TemporalFormatter;
import jdplus.toolkit.base.api.time.TimeIntervalAccessor;
import jdplus.toolkit.base.api.time.TimeIntervalFormatter;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.util.HasShortStringRepresentation;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

@ISO_8601
public final class TimePeriod
implements TimeSeriesInterval<Duration>,
Comparable<TimePeriod>,
HasShortStringRepresentation {
    @NonNull
    private final LocalDateTime start;
    @NonNull
    private final LocalDateTime end;
    private static final TimeIntervalFormatter.StartEnd ISO_8601 = TimeIntervalFormatter.StartEnd.of(TemporalFormatter.EXTENDED_CALENDAR_TIME, LocalDateTime::from, false);
    private static final TimeIntervalFormatter.StartEnd ISO_8601_CONCISE = ISO_8601.withConcise(true);

    @Override
    @NonNull
    public LocalDateTime start() {
        return this.start;
    }

    @Override
    @NonNull
    public LocalDateTime end() {
        return this.end;
    }

    @Override
    public boolean contains(LocalDateTime element) {
        return element.isBefore(this.end) && !element.isBefore(this.start);
    }

    @Override
    @NonNull
    public Duration getDuration() {
        return Duration.between(this.start, this.end);
    }

    @Override
    public int compareTo(TimePeriod t) {
        if (this.start.equals(t.start) && this.end.isAfter(t.end)) {
            return 0;
        }
        if (!this.end.isAfter(t.start)) {
            return -1;
        }
        if (!t.end.isAfter(this.start)) {
            return 1;
        }
        throw new TsException("Incompatible periods");
    }

    public String toString() {
        return ISO_8601.format(this);
    }

    @Override
    @NonNull
    public String toShortString() {
        return ISO_8601_CONCISE.format(this);
    }

    @NonNull
    public static TimePeriod parse(@NonNull CharSequence text) throws DateTimeParseException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ISO_8601.parse(text, TimePeriod::from);
    }

    @NonNull
    public static TimePeriod from(@NonNull TimeIntervalAccessor timeInterval) {
        if (timeInterval == null) {
            throw new NullPointerException("timeInterval is marked non-null but is null");
        }
        return TimePeriod.of(LocalDateTime.from(timeInterval.start()), LocalDateTime.from(timeInterval.end()));
    }

    @Generated
    private TimePeriod(@NonNull LocalDateTime start, @NonNull LocalDateTime end) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        this.start = start;
        this.end = end;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull TimePeriod of(@NonNull LocalDateTime start, @NonNull LocalDateTime end) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        return new TimePeriod(start, end);
    }

    @NonNull
    @Generated
    public LocalDateTime getStart() {
        return this.start;
    }

    @NonNull
    @Generated
    public LocalDateTime getEnd() {
        return this.end;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimePeriod)) {
            return false;
        }
        TimePeriod other = (TimePeriod)o;
        LocalDateTime this$start = this.getStart();
        LocalDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        LocalDateTime this$end = this.getEnd();
        LocalDateTime other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        LocalDateTime $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }
}

