/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.r;

import jdplus.toolkit.base.api.data.AggregationType;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;
import lombok.Generated;

public final class SaUtility {
    public static double compareAnnualTotals(TsData y, TsData sa) {
        DescriptiveStatistics ds = DescriptiveStatistics.of((DoubleSeq)y.getValues());
        double scale = ds.getRmse();
        TsData ya = y.aggregate(TsUnit.P1Y, AggregationType.Sum, true);
        TsData saa = sa.aggregate(TsUnit.P1Y, AggregationType.Sum, true);
        double maxAnnualDifference = 0.0;
        for (int k = 0; k < ya.length(); ++k) {
            double dcur = Math.abs(ya.getValue(k) - saa.getValue(k));
            if (!(dcur > maxAnnualDifference)) continue;
            maxAnnualDifference = dcur;
        }
        return maxAnnualDifference / ((double)y.getAnnualFrequency() * scale);
    }

    @Generated
    private SaUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

