/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl.roots;

import internal.toolkit.base.core.math.functions.gsl.roots.FDFSolver;
import internal.toolkit.base.core.math.functions.gsl.roots.GslRootException;
import java.util.function.DoubleUnaryOperator;

public class NewtonSolver
extends FDFSolver {
    public NewtonSolver(DoubleUnaryOperator fn, DoubleUnaryOperator dfn, double root) {
        this.function = fn;
        this.functionDf = dfn;
        this.root = root;
        this.f = fn.applyAsDouble(root);
        this.df = dfn.applyAsDouble(root);
    }

    @Override
    public void iterate() {
        if (this.df == 0.0) {
            throw new GslRootException("Derivative is zero");
        }
        this.root -= this.f / this.df;
        this.f = this.function.applyAsDouble(this.root);
        this.df = this.functionDf.applyAsDouble(this.root);
        if (!Double.isFinite(this.f)) {
            throw new GslRootException("Function value is not finite");
        }
    }
}

