/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.accumulator;

import jdplus.toolkit.base.api.data.DoubleSeq;
import lombok.Generated;

public final class AccSum {
    private static final double EPS = (double)1.110223E-16f;
    private static final double ETA = Double.MIN_VALUE;
    private static final double LOG2 = Math.log(2.0);

    private static double log2(double x) {
        return Math.log(x) / LOG2;
    }

    public static void fastTwoSum(double a, double b, AccurateDouble sum) {
        double x = a + b;
        double y = a - x;
        sum.value = x;
        sum.error = y + b;
    }

    public static void twoProduct(double a, double b, AccurateDouble prod) {
        double x = a * b;
        AccurateDouble sa = AccurateDouble.split(a);
        AccurateDouble sb = AccurateDouble.split(b);
        double y = sa.error * sb.error - (x - sa.value * sb.value - sa.error * sb.value - sa.value * sb.error);
        prod.value = x;
        prod.error = y;
    }

    public static double fastAccurateSum(DoubleSeq seq) {
        DoubleSeq P;
        double t;
        double tau;
        double phi;
        int n = seq.length();
        if (n == 0) {
            return 0.0;
        }
        if (n == 1) {
            return seq.get(0);
        }
        double c2 = 1.0 - (double)(3 * n + 1) * (double)1.110223E-16f;
        double c3 = 2.220446049250313E-16;
        double c4 = 0.9999999999999999;
        double c5 = (double)(2 * n * (n + 2)) * (double)1.110223E-16f;
        double c6 = 0.9999999999999994;
        double c7 = 1.5000000000000004 * ((double)n * (double)1.110223E-16f);
        double c8 = (double)(2 * n) * (double)1.110223E-16f;
        double c9 = 4.450147717014403E-308;
        double T2 = seq.reduce(0.0, (x, y) -> x + Math.abs(y));
        if (T2 <= c8) {
            return T2;
        }
        double res = seq.sum();
        double tp = 0.0;
        double[] p = seq.toArray();
        do {
            double sigma0;
            double z = sigma0 = 2.0 * T2 / c2;
            int i = 0;
            while (i < p.length) {
                double z0 = z;
                double q = (z += p[i]) - z0;
                int n2 = i++;
                p[n2] = p[n2] - q;
            }
            tau = z - sigma0;
            t = tp;
            tp = t + tau;
            P = DoubleSeq.of((double[])p);
            if (tp == 0.0) {
                return AccSum.fastAccurateSum(P.select(x -> x != 0.0));
            }
            double nq = sigma0 / c3;
            double u = Math.abs(nq / c4 - nq);
            phi = c5 * u / c6;
            T2 = Math.min(c7 * sigma0, c8 * u);
        } while (!(Math.abs(tp) >= phi) && !(4.0 * T2 <= c9));
        double tau2 = t - tp + tau;
        res = tp + (tau2 + P.sum());
        return res;
    }

    @Generated
    private AccSum() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class AccurateDouble {
        public double value;
        public double error;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("value=").append(this.value).append(", error=").append(this.error);
            return builder.toString();
        }

        public static AccurateDouble split(double a) {
            AccurateDouble s = new AccurateDouble();
            double factor = Math.pow(2.0, Math.ceil(AccSum.log2(1.8014398509481984E16) / 2.0) + 1.0);
            double c = factor * a;
            double ca = c - a;
            s.value = c - ca;
            s.error = a - s.value;
            return s;
        }
    }
}

