/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.dstats;

import internal.toolkit.base.core.dstats.ProbInvFinder;
import internal.toolkit.base.core.dstats.Utility;
import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.dstats.BoundaryType;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.dstats.SpecialFunctions;

public class T
implements ContinuousDistribution {
    private static final Normal N = new Normal();
    static final double[][] COEFF = new double[][]{{1.0, 1.0, 0.0, 0.0, 0.0}, {3.0, 16.0, 5.0, 0.0, 0.0}, {-15.0, 17.0, 19.0, 3.0, 0.0}, {-945.0, -1920.0, 1482.0, 776.0, 79.0}};
    static final double[] DENOM = new double[]{4.0, 96.0, 384.0, 92160.0};
    static final int[] DEG = new int[]{2, 3, 4, 5};
    private final double df;
    private final AtomicReference<Chi2> chi2;

    static double calcInitT(double p, double df) {
        double x = N.getProbabilityInverse(p, ProbabilityType.Lower);
        double xx = x * x;
        double sum = x;
        double denpow = 1.0;
        for (int i = 0; i < 4; ++i) {
            double term = Utility.calcPoly(COEFF[i], DEG[i], xx) * x;
            sum += term / ((denpow *= df) * DENOM[i]);
        }
        return sum;
    }

    public T(double df) {
        if (df < 0.0) {
            throw new IllegalArgumentException("The degrees of freedom should be strictly positive");
        }
        this.df = df;
        this.chi2 = new AtomicReference();
    }

    public double getDegreesofFreedom() {
        return this.df;
    }

    public double getDensity(double x) {
        return SpecialFunctions.studentDensity(x, this.df);
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("T with ");
        sb.append(this.df);
        sb.append(" degrees of freedom");
        return sb.toString();
    }

    public double getExpectation() {
        if (this.df <= 1.0) {
            throw new DStatException("Undefined", "T");
        }
        return 0.0;
    }

    public double getVariance() {
        if (this.df <= 1.0) {
            throw new DStatException("Undefined", "T");
        }
        if (this.df <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.df / (this.df - 2.0);
    }

    public double getLeftBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getProbability(double x, ProbabilityType pt) {
        if (pt == ProbabilityType.Point) {
            return 0.0;
        }
        if (x == 0.0) {
            return 0.5;
        }
        double res = SpecialFunctions.studentProbability(x, this.df);
        if (pt == ProbabilityType.Upper) {
            res = 1.0 - res;
        }
        return res;
    }

    public double getProbabilityInverse(double p, ProbabilityType pt) {
        if (pt == ProbabilityType.Upper) {
            p = 1.0 - p;
        }
        if (p < 1.0E-15 || 1.0 - p < 1.0E-15) {
            throw new DStatException("Can't compute probability inverse (value is too near 0 or 1)");
        }
        if (Math.abs(p - 0.5) < 1.0E-15) {
            return 0.0;
        }
        double start = T.calcInitT(p, this.df);
        return ProbInvFinder.find(p, start, 1.0E-15, 1.0E-9, this);
    }

    public double getRightBound() {
        return Double.POSITIVE_INFINITY;
    }

    public BoundaryType hasLeftBound() {
        return BoundaryType.None;
    }

    public BoundaryType hasRightBound() {
        return BoundaryType.None;
    }

    public boolean isSymmetrical() {
        return true;
    }

    public double random(RandomNumberGenerator rng) {
        Chi2 cdenom = this.chi2.get();
        if (cdenom == null) {
            cdenom = new Chi2(this.df);
            this.chi2.set(cdenom);
        }
        return N.random(rng) / Math.sqrt(cdenom.random(rng) / this.df);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("T(");
        sb.append(this.df);
        sb.append(')');
        return sb.toString();
    }
}

