/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearsystem;

import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.data.normalizer.SafeNormalizer;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.Gauss;
import jdplus.toolkit.base.core.math.matrices.decomposition.LUDecomposition;

public class LULinearSystemSolver
implements LinearSystemSolver {
    private final LUDecomposition.Decomposer decomposer;
    private final double eps;
    private final boolean normalize;

    public static Builder builder() {
        return new Builder();
    }

    private LULinearSystemSolver(LUDecomposition.Decomposer decomposer, double eps, boolean normalize) {
        this.decomposer = decomposer;
        this.eps = eps;
        this.normalize = normalize;
    }

    @Override
    public void solve(FastMatrix A, DataBlock b) {
        FastMatrix An;
        if (this.normalize) {
            An = A.deepClone();
            DataBlockIterator rows = An.rowsIterator();
            SafeNormalizer sn = new SafeNormalizer();
            int i = 0;
            while (rows.hasNext()) {
                double factor = sn.normalize(rows.next());
                b.mul(i++, factor);
            }
        } else {
            An = A;
        }
        LUDecomposition lu = this.decomposer.decompose(An, this.eps);
        lu.solve(b);
    }

    @Override
    public void solve(FastMatrix A, FastMatrix B) {
        FastMatrix An;
        double[] factor = null;
        if (this.normalize) {
            An = A.deepClone();
            DataBlockIterator rows = An.rowsIterator();
            SafeNormalizer sn = new SafeNormalizer();
            factor = new double[A.getRowsCount()];
            int i = 0;
            while (rows.hasNext()) {
                factor[i++] = sn.normalize(rows.next());
            }
        } else {
            An = A;
        }
        LUDecomposition lu = this.decomposer.decompose(An, this.eps);
        lu.solve(B);
        if (factor != null) {
            DataBlockIterator rows = B.rowsIterator();
            int r = 0;
            while (rows.hasNext()) {
                rows.next().div(factor[r++]);
            }
        }
    }

    public static class Builder {
        private LUDecomposition.Decomposer decomposer = (M, e) -> Gauss.decompose(M, e);
        private double eps = Constants.getEpsilon();
        private boolean normalize = false;

        private Builder() {
        }

        public Builder decomposer(LUDecomposition.Decomposer decomposer) {
            this.decomposer = decomposer;
            return this;
        }

        public Builder normalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public Builder precision(double eps) {
            this.eps = eps;
            return this;
        }

        public LULinearSystemSolver build() {
            return new LULinearSystemSolver(this.decomposer, this.eps, this.normalize);
        }
    }
}

