/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.matrices.DataPointer;

public class LAIC1 {
    private double sestpr = 1.0;
    private double s;
    private double c;

    public void minSingularValue(int j, DataPointer x, double sest, DataPointer w, double gamma) {
        double eps = Constants.getEpsilon();
        double alpha = x.dot(j, w);
        double aalpha = Math.abs(alpha);
        double agamma = Math.abs(gamma);
        double asest = Math.abs(sest);
        if (sest == 0.0) {
            double cosine;
            double sine;
            this.sestpr = 0.0;
            if (agamma == 0.0 && aalpha == 0.0) {
                sine = 1.0;
                cosine = 0.0;
            } else {
                sine = -gamma;
                cosine = alpha;
            }
            double s1 = Math.max(Math.abs(sine), Math.abs(cosine));
            this.s = sine / s1;
            this.c = cosine / s1;
            double tmp = Math.sqrt(sine * sine + cosine * cosine);
            this.s /= tmp;
            this.c /= tmp;
        } else if (agamma <= eps * asest) {
            this.s = 0.0;
            this.c = 1.0;
            this.sestpr = agamma;
        } else if (aalpha <= eps * asest) {
            double s1 = agamma;
            double s2 = asest;
            if (s1 <= s2) {
                this.s = 0.0;
                this.c = 1.0;
                this.sestpr = s1;
            } else {
                this.s = 1.0;
                this.c = 0.0;
                this.sestpr = s2;
            }
        } else if (asest <= eps * aalpha || asest <= eps * agamma) {
            double s1 = agamma;
            double s2 = agamma;
            if (s1 <= s2) {
                double tmp = s1 / s2;
                this.c = Math.sqrt(1.0 + tmp * tmp);
                this.sestpr = asest * (tmp / this.c);
                this.s = -(gamma / s2) / this.c;
                this.c = Math.copySign(1.0, alpha) / this.c;
            } else {
                double tmp = s2 / s1;
                this.s = Math.sqrt(1.0 + tmp * tmp);
                this.sestpr = asest / this.s;
                this.c = alpha / s1 / this.s;
                this.s = Math.copySign(1.0, gamma) / this.s;
            }
        } else {
            double cosine;
            double sine;
            double zeta1 = alpha / asest;
            double zeta2 = gamma / asest;
            double norma = Math.max(1.0 + zeta1 * zeta1 + Math.abs(zeta1 * zeta2), Math.abs(zeta1 * zeta2) + zeta2 * zeta2);
            double test = 1.0 + 2.0 * (zeta1 - zeta2) * (zeta1 + zeta2);
            if (test >= 0.0) {
                b = (zeta1 * zeta1 + zeta2 * zeta2 + 1.0) / 2.0;
                this.c = zeta2 * zeta2;
                double t = this.c / (b + Math.sqrt(Math.abs(b * b - this.c)));
                sine = zeta1 / (1.0 - t);
                cosine = -zeta2 / t;
                this.sestpr = Math.sqrt(1.0 + 4.0 * eps * eps * norma) * asest;
            } else {
                b = (zeta2 * zeta2 + zeta1 * zeta1 - 1.0) / 2.0;
                this.c = zeta1 * zeta1;
                double t = b >= 0.0 ? -this.c / (b + Math.sqrt(b * b - this.c)) : b - Math.sqrt(b * b + this.c);
                sine = -zeta1 / t;
                cosine = -zeta2 / (1.0 + t);
                this.sestpr = Math.sqrt(1.0 + t + 4.0 * eps * eps * norma) * asest;
            }
            double tmp = Math.sqrt(sine * sine + cosine * cosine);
            this.s = sine / tmp;
            this.c = cosine / tmp;
        }
    }

    public void maxSingularValue(int j, DataPointer x, double sest, DataPointer w, double gamma) {
        double eps = Constants.getEpsilon();
        double alpha = x.dot(j, w);
        double aalpha = Math.abs(alpha);
        double agamma = Math.abs(gamma);
        double asest = Math.abs(sest);
        if (sest == 0.0) {
            double s1 = Math.max(agamma, aalpha);
            if (s1 == 0.0) {
                this.s = 0.0;
                this.c = 1.0;
                this.sestpr = 0.0;
            } else {
                this.s = alpha / s1;
                this.c = gamma / s1;
                double tmp = Math.sqrt(this.s * this.s + this.c * this.c);
                this.s /= tmp;
                this.c /= tmp;
                this.sestpr = s1 * tmp;
            }
        } else if (agamma <= eps * asest) {
            this.s = 1.0;
            this.c = 0.0;
            double tmp = Math.max(asest, aalpha);
            double s1 = asest / tmp;
            double s2 = aalpha / tmp;
            this.sestpr = tmp * Math.sqrt(s1 * s1 + s2 * s2);
        } else if (aalpha <= eps * asest) {
            double s1 = agamma;
            double s2 = asest;
            if (s1 <= s2) {
                this.s = 1.0;
                this.c = 0.0;
                this.sestpr = s2;
            } else {
                this.s = 0.0;
                this.c = 1.0;
                this.sestpr = s1;
            }
        } else if (asest <= eps * aalpha || asest <= eps * agamma) {
            double s1 = agamma;
            double s2 = aalpha;
            if (s1 <= s2) {
                double tmp = s1 / s2;
                this.s = Math.sqrt(1.0 + tmp * tmp);
                this.sestpr = s2 * this.s;
                this.c = gamma / s2 / this.s;
                this.s = Math.copySign(1.0, alpha) / this.s;
            } else {
                double tmp = s2 / s1;
                this.c = Math.sqrt(1.0 + tmp * tmp);
                this.sestpr = s1 * this.c;
                this.s = alpha / s1 / this.c;
                this.c = Math.copySign(1.0, gamma) / this.c;
            }
        } else {
            double zeta1 = alpha / asest;
            double zeta2 = gamma / asest;
            double b = (1.0 - zeta1 * zeta1 - zeta2 * zeta2) / 2.0;
            this.c = zeta1 * zeta1;
            double t = b > 0.0 ? this.c / (b + Math.sqrt(b * b + this.c)) : Math.sqrt(b * b + this.c) - b;
            double sine = -zeta1 / t;
            double cosine = -zeta2 / (1.0 + t);
            double tmp = Math.sqrt(sine * sine + cosine * cosine);
            this.s = sine / tmp;
            this.c = cosine / tmp;
            this.sestpr = Math.sqrt(t + 1.0) * asest;
        }
    }

    public double getSestpr() {
        return this.sestpr;
    }

    public double getS() {
        return this.s;
    }

    public double getC() {
        return this.c;
    }
}

