/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.diagnostics;

import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.core.regarima.diagnostics.OutOfSampleDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regarima.diagnostics.OutOfSampleDiagnosticsFactory;
import jdplus.toolkit.base.core.regarima.tests.OneStepAheadForecastingTest;

public class OutOfSampleDiagnostics
implements Diagnostics {
    private final double ub;
    private final double bb;
    private double mpval;
    private double vpval;

    static OutOfSampleDiagnostics create(OutOfSampleDiagnosticsConfiguration config, OneStepAheadForecastingTest test) {
        try {
            if (test == null) {
                return null;
            }
            return new OutOfSampleDiagnostics(config, test);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private OutOfSampleDiagnostics(OutOfSampleDiagnosticsConfiguration config, OneStepAheadForecastingTest test) {
        this.bb = config.getBadThreshold();
        this.ub = config.getUncertainThreshold();
        this.test(test, config.isDiagnosticOnMean(), config.isDiagnosticOnVariance());
    }

    private void test(OneStepAheadForecastingTest xtest, boolean m, boolean v) {
        this.mpval = Double.NaN;
        this.vpval = Double.NaN;
        if (xtest != null) {
            if (m) {
                this.mpval = xtest.outOfSampleMeanTest().getPvalue();
            }
            if (v) {
                this.vpval = xtest.sameVarianceTest().getPvalue();
            }
        }
    }

    public String getName() {
        return "Out-of-sample";
    }

    public List<String> getTests() {
        return OutOfSampleDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        double r = this.getValue(test);
        if (Double.isNaN(r)) {
            return ProcQuality.Undefined;
        }
        if (r < this.bb) {
            return ProcQuality.Bad;
        }
        if (r < this.ub) {
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Good;
    }

    public double getValue(String test) {
        switch (test) {
            case "mean": {
                return this.mpval;
            }
            case "mse": {
                return this.vpval;
            }
        }
        return Double.NaN;
    }

    public List<String> getWarnings() {
        return Collections.emptyList();
    }
}

