/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.sarima.estimation;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.FunctionException;
import jdplus.toolkit.base.core.math.functions.ParamValidation;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;

public class SarimaFixedMapping
implements IArimaMapping<SarimaModel> {
    static final double REPS = 0.01;
    final SarimaMapping mapper;
    final boolean[] fixedItems;
    final double[] parameters;
    private static final double RMAX = 0.99;
    private static final int MAX_ITER = 20;
    private static final double K = 0.2;
    private static final double MK = -1.25;

    public boolean[] getFixedItems() {
        return (boolean[])this.fixedItems.clone();
    }

    public SarimaFixedMapping(SarimaOrders spec, DoubleSeq p, boolean[] fixed) {
        this.mapper = SarimaMapping.of(spec);
        this.fixedItems = (boolean[])fixed.clone();
        this.parameters = p.toArray();
    }

    @Override
    public boolean checkBoundaries(DoubleSeq inparams) {
        return this.mapper.checkBoundaries((DoubleSeq)this.fullParameters(inparams));
    }

    @Override
    public double epsilon(DoubleSeq inparams, int idx) {
        return this.mapper.epsilon((DoubleSeq)this.fullParameters(inparams), this.fullIndex(idx));
    }

    private int fixed() {
        int n = 0;
        for (int i = 0; i < this.fixedItems.length; ++i) {
            if (!this.fixedItems[i]) continue;
            ++n;
        }
        return n;
    }

    public DataBlock freeParameters(DoubleSeq allParams) {
        DataBlock free = DataBlock.make(this.getDim());
        this.save(allParams, free);
        return free;
    }

    public int fullIndex(int freeIndex) {
        int cur = -1;
        for (int i = 0; i < this.fixedItems.length; ++i) {
            if (!this.fixedItems[i]) {
                ++cur;
            }
            if (cur != freeIndex) continue;
            return i;
        }
        return -1;
    }

    public DataBlock fullParameters(DoubleSeq freeParams) {
        double[] buffer = (double[])this.parameters.clone();
        int i = 0;
        int j = 0;
        while (i < freeParams.length()) {
            while (this.fixedItems[j]) {
                ++j;
            }
            buffer[j] = freeParams.get(i);
            ++i;
            ++j;
        }
        return DataBlock.of(buffer);
    }

    @Override
    public int getDim() {
        return this.mapper.getSpec().getParametersCount() - this.fixed();
    }

    @Override
    public double lbound(int idx) {
        return this.mapper.lbound(this.fullIndex(idx));
    }

    @Override
    public SarimaModel map(DoubleSeq p) {
        return this.mapper.map((DoubleSeq)this.fullParameters(p));
    }

    @Override
    public DoubleSeq parametersOf(SarimaModel t) {
        return this.freeParameters(this.mapper.parametersOf(t));
    }

    private void save(DoubleSeq all, DataBlock free) {
        int j = 0;
        for (int i = 0; i < this.fixedItems.length; ++i) {
            if (this.fixedItems[i]) continue;
            free.set(j++, all.get(i));
        }
    }

    @Override
    public double ubound(int idx) {
        return this.mapper.ubound(this.fullIndex(idx));
    }

    @Override
    public ParamValidation validate(DataBlock ioparams) {
        DataBlock tmp = this.fullParameters((DoubleSeq)ioparams);
        if (this.mapper.checkBoundaries((DoubleSeq)tmp)) {
            this.save((DoubleSeq)tmp, ioparams);
            return ParamValidation.Valid;
        }
        int beg = 0;
        int end = this.mapper.getSpec().getP();
        boolean changed = false;
        if (beg != end) {
            if (this.isFree(beg, end)) {
                if (SarimaFixedMapping.stabilize(tmp, beg, end - beg, 0.99)) {
                    changed = true;
                }
            } else if (this.fstabilize(tmp, beg, end - beg)) {
                changed = true;
            }
        }
        if ((beg = end) != (end += this.mapper.getSpec().getBp())) {
            if (this.isFree(beg, end)) {
                if (SarimaFixedMapping.stabilize(tmp, beg, end - beg, 0.99)) {
                    changed = true;
                }
            } else if (this.fstabilize(tmp, beg, end - beg)) {
                changed = true;
            }
        }
        if ((beg = end) != (end += this.mapper.getSpec().getQ())) {
            if (this.isFree(beg, end)) {
                if (SarimaFixedMapping.stabilize(tmp, beg, end - beg, 1.0)) {
                    changed = true;
                }
            } else if (this.fstabilize(tmp, beg, end - beg)) {
                changed = true;
            }
        }
        if ((beg = end) != (end += this.mapper.getSpec().getBq())) {
            if (this.isFree(beg, end)) {
                if (SarimaFixedMapping.stabilize(tmp, beg, end - beg, 1.0)) {
                    changed = true;
                }
            } else if (this.fstabilize(tmp, beg, end - beg)) {
                changed = true;
            }
        }
        if (changed) {
            this.save((DoubleSeq)tmp, ioparams);
            return ParamValidation.Changed;
        }
        return ParamValidation.Valid;
    }

    public FastMatrix expandCovariance(FastMatrix cov) {
        int dim = this.getDim();
        if (cov.getColumnsCount() != dim) {
            return null;
        }
        int[] idx = new int[dim];
        int j = 0;
        for (int i = 0; i < this.fixedItems.length; ++i) {
            if (this.fixedItems[i]) continue;
            idx[j++] = i;
        }
        FastMatrix ecov = FastMatrix.make(this.fixedItems.length, this.fixedItems.length);
        for (int i = 0; i < dim; ++i) {
            for (int j2 = 0; j2 <= i; ++j2) {
                double s = cov.get(i, j2);
                ecov.set(idx[i], idx[j2], s);
                if (i == j2) continue;
                ecov.set(idx[j2], idx[i], s);
            }
        }
        return ecov;
    }

    private boolean isFree(int beg, int end) {
        for (int i = beg; i < end; ++i) {
            if (!this.fixedItems[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean stabilize(DataBlock c, int start, int nc, double rmax) {
        Polynomial sp;
        if (nc == 0) {
            return false;
        }
        if (SarimaMapping.checkStability((DoubleSeq)c.extract(start, nc))) {
            return false;
        }
        if (nc == 1) {
            double c0 = c.get(start);
            double cabs = Math.abs(c0);
            if (rmax < 1.0 && Math.abs(cabs - 1.0) <= 0.01) {
                c.set(start, c0 > 0.0 ? rmax : -rmax);
                return true;
            }
            if (cabs > 1.0) {
                c.set(start, 1.0 / c0);
                return true;
            }
            return false;
        }
        double[] ctmp = new double[nc + 1];
        ctmp[0] = 1.0;
        for (int i = 0; i < nc; ++i) {
            ctmp[1 + i] = c.get(start + i);
        }
        Polynomial p = Polynomial.of(ctmp);
        if (p != (sp = SarimaFixedMapping.stabilize(p, rmax))) {
            for (int i = 0; i < nc; ++i) {
                c.set(start + i, sp.get(1 + i));
            }
            return true;
        }
        return false;
    }

    private static Polynomial stabilize(Polynomial p, double rmax) {
        if (p == null) {
            return null;
        }
        Complex[] roots = p.roots();
        boolean changed = false;
        for (int i = 0; i < roots.length; ++i) {
            Complex root = roots[i];
            double n = 1.0 / roots[i].abs();
            if (rmax < 1.0 && Math.abs(n - 1.0) <= 0.01) {
                roots[i] = root.times(n / rmax);
                changed = true;
                continue;
            }
            if (!(n > 1.0)) continue;
            roots[i] = root.inv();
            changed = true;
        }
        if (!changed) {
            return p;
        }
        Polynomial ptmp = Polynomial.fromComplexRoots(roots);
        ptmp = ptmp.divide(ptmp.get(0));
        return ptmp;
    }

    private boolean fstabilize(DataBlock ioparams, int beg, int n) {
        DataBlock extract = ioparams.extract(beg, n);
        if (SarimaMapping.checkStability((DoubleSeq)extract)) {
            return false;
        }
        DataBlock tmp = DataBlock.make(n);
        int k = 0;
        do {
            for (int i = 0; i < n; ++i) {
                int j;
                if (this.fixedItems[beg + i]) continue;
                tmp.copy(extract);
                for (j = 0; j < n; ++j) {
                    if (this.fixedItems[beg + j]) continue;
                    tmp.set(j, 0.0);
                }
                tmp.set(i, 0.2);
                for (j = 0; j < 10; ++j) {
                    if (SarimaMapping.checkStability((DoubleSeq)tmp.extract(0, n))) {
                        extract.copy(tmp);
                        return true;
                    }
                    tmp.mul(i, -1.25);
                }
            }
        } while (++k <= 20);
        throw new FunctionException("Invalid mapping");
    }

    @Override
    public String getDescription(int idx) {
        return this.mapper.getDescription(this.fullIndex(idx));
    }

    @Override
    public DoubleSeq getDefaultParameters() {
        int i;
        SarimaOrders spec = this.mapper.getSpec();
        double[] p = new double[this.getDim()];
        int nar = spec.getP() + spec.getBp();
        int j = 0;
        for (i = 0; i < nar; ++i) {
            if (this.fixedItems[i]) continue;
            p[j++] = -0.1;
        }
        for (i = nar; i < p.length; ++i) {
            if (this.fixedItems[i]) continue;
            p[j++] = -0.2;
        }
        return DoubleSeq.of((double[])p);
    }

    @Override
    public IArimaMapping<SarimaModel> stationaryMapping() {
        return new SarimaFixedMapping(SarimaOrders.stationary((SarimaOrders)this.mapper.getSpec()), DoubleSeq.of((double[])this.parameters), this.fixedItems);
    }
}

