/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf;

import java.util.Arrays;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class Initialization
implements ISsfInitialization {
    private final int dim;
    private final int diffuseDim;
    private final double[] a0;
    private final FastMatrix Pf;
    private final FastMatrix Pi;
    private final FastMatrix B;

    @Override
    public int getStateDim() {
        return this.dim;
    }

    @Override
    public boolean isDiffuse() {
        return this.diffuseDim > 0;
    }

    @Override
    public int getDiffuseDim() {
        return this.diffuseDim;
    }

    @Override
    public void diffuseConstraints(FastMatrix b) {
        if (this.B != null) {
            b.copy(this.B);
        }
    }

    @Override
    public void a0(DataBlock a) {
        if (this.a0 != null) {
            a.copyFrom(this.a0, 0);
        }
    }

    @Override
    public void Pf0(FastMatrix pf) {
        if (this.Pf != null) {
            pf.copy(this.Pf);
        }
    }

    @Override
    public void Pi0(FastMatrix pi) {
        if (this.Pi != null) {
            pi.copy(this.Pi);
        } else {
            ISsfInitialization.super.Pi0(pi);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.a0 == null) {
            builder.append("a0:").append(System.lineSeparator()).append("0");
        } else {
            DataBlock a = DataBlock.of(this.a0);
            builder.append(a.toString("0.#####"));
        }
        builder.append(System.lineSeparator());
        if (this.Pf == null) {
            builder.append("Pf0:").append(System.lineSeparator()).append("0");
        } else {
            builder.append(this.Pf.toString("0.#####"));
        }
        builder.append(System.lineSeparator());
        if (this.B == null) {
            builder.append("B:").append(System.lineSeparator()).append("0");
        } else {
            builder.append(this.B.toString("0.#####"));
        }
        return builder.toString();
    }

    @Generated
    Initialization(int dim, int diffuseDim, double[] a0, FastMatrix Pf, FastMatrix Pi, FastMatrix B) {
        this.dim = dim;
        this.diffuseDim = diffuseDim;
        this.a0 = a0;
        this.Pf = Pf;
        this.Pi = Pi;
        this.B = B;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public int getDim() {
        return this.dim;
    }

    @Generated
    public double[] getA0() {
        return this.a0;
    }

    @Generated
    public FastMatrix getPf() {
        return this.Pf;
    }

    @Generated
    public FastMatrix getPi() {
        return this.Pi;
    }

    @Generated
    public FastMatrix getB() {
        return this.B;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Initialization)) {
            return false;
        }
        Initialization other = (Initialization)o;
        if (this.getDim() != other.getDim()) {
            return false;
        }
        if (this.getDiffuseDim() != other.getDiffuseDim()) {
            return false;
        }
        if (!Arrays.equals(this.getA0(), other.getA0())) {
            return false;
        }
        FastMatrix this$Pf = this.getPf();
        FastMatrix other$Pf = other.getPf();
        if (this$Pf == null ? other$Pf != null : !this$Pf.equals(other$Pf)) {
            return false;
        }
        FastMatrix this$Pi = this.getPi();
        FastMatrix other$Pi = other.getPi();
        if (this$Pi == null ? other$Pi != null : !this$Pi.equals(other$Pi)) {
            return false;
        }
        FastMatrix this$B = this.getB();
        FastMatrix other$B = other.getB();
        return !(this$B == null ? other$B != null : !this$B.equals(other$B));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDim();
        result = result * 59 + this.getDiffuseDim();
        result = result * 59 + Arrays.hashCode(this.getA0());
        FastMatrix $Pf = this.getPf();
        result = result * 59 + ($Pf == null ? 43 : $Pf.hashCode());
        FastMatrix $Pi = this.getPi();
        result = result * 59 + ($Pi == null ? 43 : $Pi.hashCode());
        FastMatrix $B = this.getB();
        result = result * 59 + ($B == null ? 43 : $B.hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private int dim;
        @Generated
        private int diffuseDim;
        @Generated
        private double[] a0;
        @Generated
        private FastMatrix Pf;
        @Generated
        private FastMatrix Pi;
        @Generated
        private FastMatrix B;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder dim(int dim) {
            this.dim = dim;
            return this;
        }

        @Generated
        public @NonNull Builder diffuseDim(int diffuseDim) {
            this.diffuseDim = diffuseDim;
            return this;
        }

        @Generated
        public @NonNull Builder a0(double[] a0) {
            this.a0 = a0;
            return this;
        }

        @Generated
        public @NonNull Builder Pf(FastMatrix Pf) {
            this.Pf = Pf;
            return this;
        }

        @Generated
        public @NonNull Builder Pi(FastMatrix Pi) {
            this.Pi = Pi;
            return this;
        }

        @Generated
        public @NonNull Builder B(FastMatrix B) {
            this.B = B;
            return this;
        }

        @Generated
        public @NonNull Initialization build() {
            return new Initialization(this.dim, this.diffuseDim, this.a0, this.Pf, this.Pi, this.B);
        }

        @Generated
        public @NonNull String toString() {
            return "Initialization.Builder(dim=" + this.dim + ", diffuseDim=" + this.diffuseDim + ", a0=" + Arrays.toString(this.a0) + ", Pf=" + String.valueOf(this.Pf) + ", Pi=" + String.valueOf(this.Pi) + ", B=" + String.valueOf(this.B) + ")";
        }
    }
}

