/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfLoading;

public class TimeInvariantLoading
implements ISsfLoading {
    private final DataBlock Z;
    private static final String FMT = "0.#####";

    public static TimeInvariantLoading of(int dim, ISsfLoading loading) {
        if (!loading.isTimeInvariant()) {
            return null;
        }
        DataBlock Z = DataBlock.make(dim);
        loading.Z(0, Z);
        return new TimeInvariantLoading(Z);
    }

    public TimeInvariantLoading(DataBlock Z) {
        this.Z = Z;
    }

    @Override
    public boolean isTimeInvariant() {
        return true;
    }

    @Override
    public void Z(int pos, DataBlock z) {
        z.copy(this.Z);
    }

    @Override
    public double ZX(int pos, DataBlock m) {
        return this.Z.dot(m);
    }

    @Override
    public double ZVZ(int pos, FastMatrix V) {
        DataBlock zv = DataBlock.make(V.getColumnsCount());
        zv.product(this.Z, V.columnsIterator());
        return zv.dot(this.Z);
    }

    @Override
    public void VpZdZ(int pos, FastMatrix V, double d) {
        if (d == 0.0) {
            return;
        }
        DataBlockIterator cols = V.columnsIterator();
        DoubleSeqCursor.OnMutable z = this.Z.cursor();
        while (cols.hasNext()) {
            cols.next().addAY(d * z.getAndNext(), this.Z);
        }
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        x.addAY(d, this.Z);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Z:\r\n").append(this.Z.toString(FMT)).append("\r\n");
        return builder.toString();
    }
}

