/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.basic.MeasurementsError;
import jdplus.toolkit.base.core.ssf.basic.TimeInvariantLoading;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfErrors;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfMeasurements;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.ISsfMeasurement;

public class TimeInvariantMeasurements
implements ISsfMeasurements {
    private final FastMatrix Z;
    private final ISsfErrors errors;

    public static TimeInvariantMeasurements of(int dim, ISsfMeasurements measurements) {
        if (!measurements.isTimeInvariant()) {
            return null;
        }
        int m = measurements.getCount();
        FastMatrix Z = FastMatrix.make(m, dim);
        for (int i = 0; i < m; ++i) {
            measurements.loading(i).Z(0, Z.row(i));
        }
        ISsfErrors errors = measurements.errors();
        if (errors == null) {
            return new TimeInvariantMeasurements(Z, null, null);
        }
        FastMatrix H = FastMatrix.square(m);
        FastMatrix R = FastMatrix.square(m);
        errors.H(0, H);
        errors.R(0, R);
        return new TimeInvariantMeasurements(Z, H, R);
    }

    public static TimeInvariantMeasurements of(int dim, ISsfMeasurement measurement) {
        if (!measurement.isTimeInvariant()) {
            return null;
        }
        FastMatrix Z = FastMatrix.make(1, dim);
        measurement.loading().Z(0, Z.row(0));
        ISsfError error = measurement.error();
        if (error == null) {
            return new TimeInvariantMeasurements(Z, null, null);
        }
        double v = error.at(0);
        FastMatrix H = FastMatrix.square(1);
        H.set(0, 0, v);
        FastMatrix R = FastMatrix.square(1);
        R.set(0, 0, Math.sqrt(v));
        return new TimeInvariantMeasurements(Z, H, R);
    }

    public TimeInvariantMeasurements(FastMatrix Z, FastMatrix H, FastMatrix R) {
        this.Z = Z;
        this.errors = H == null && R == null ? null : (H != null && H.isDiagonal() ? MeasurementsError.of((DoubleSeq)H.diagonal()) : MeasurementsError.of(H, R));
    }

    @Override
    public boolean isTimeInvariant() {
        return true;
    }

    @Override
    public int getCount() {
        return this.Z.getRowsCount();
    }

    @Override
    public ISsfLoading loading(int equation) {
        return new TimeInvariantLoading(this.Z.row(equation));
    }

    @Override
    public ISsfErrors errors() {
        return this.errors;
    }
}

