/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree.thorney;

import dr.evolution.datatype.ContinuousDataType;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.bigfasttree.thorney.MutationBranchMap;
import dr.evomodel.bigfasttree.thorney.MutationList;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class FixedTreeBranchLengthProvider
extends MutationBranchMap.AbstractMutationBranchMap {
    public static final String FIXED_TREE_BRANCHLENGTH_PROVIDER = "FixedTreeBranchLengthProvider";
    private final double[] branchLengths;
    private final Tree tree;

    public FixedTreeBranchLengthProvider(Tree tree, Tree tree2, Double d, Double d2, boolean bl) {
        super(ContinuousDataType.INSTANCE);
        Object object;
        Serializable serializable;
        int n;
        this.tree = tree;
        this.branchLengths = new double[tree2.getNodeCount()];
        if (this.tree.getNodeCount() != tree2.getNodeCount()) {
            throw new RuntimeException("The number of nodes in the datatree does not match that in input tree");
        }
        HashMap<String, NodeRef> hashMap = new HashMap<String, NodeRef>();
        for (n = 0; n < tree2.getExternalNodeCount(); ++n) {
            serializable = tree2.getExternalNode(n);
            hashMap.put(tree2.getNodeTaxon((NodeRef)serializable).getId(), (NodeRef)serializable);
        }
        for (n = 0; n < tree.getExternalNodeCount(); ++n) {
            serializable = tree.getExternalNode(n);
            object = tree.getNodeTaxon((NodeRef)serializable).getId();
            NodeRef nodeRef = (NodeRef)hashMap.get(object);
            double d3 = bl ? (double)Math.round(tree2.getBranchLength(nodeRef) * d) : tree2.getBranchLength(nodeRef) * d;
            this.branchLengths[serializable.getNumber()] = Math.max(d2, d3);
        }
        HashMap<BitSet, NodeRef> hashMap2 = this.getBitSetNodeMap(tree2, tree2);
        serializable = this.getBitSetNodeMap(tree2, tree);
        object = new HashMap();
        for (Map.Entry entry : hashMap2.entrySet()) {
            ((HashMap)object).put((NodeRef)entry.getValue(), (NodeRef)serializable.get(entry.getKey()));
        }
        for (int i = 0; i < tree2.getInternalNodeCount(); ++i) {
            NodeRef nodeRef = tree2.getInternalNode(i);
            NodeRef nodeRef2 = (NodeRef)((HashMap)object).get(nodeRef);
            double d4 = bl ? (double)Math.round(tree2.getBranchLength(nodeRef) * d) : tree2.getBranchLength(nodeRef) * d;
            this.branchLengths[nodeRef2.getNumber()] = Math.max(d2, d4);
        }
    }

    public FixedTreeBranchLengthProvider(Tree tree, Tree tree2) {
        this(tree, tree2, 1.0, 0.0, true);
    }

    public double getBranchLength(Tree tree, NodeRef nodeRef) {
        if (this.tree == tree) {
            return this.branchLengths[nodeRef.getNumber()];
        }
        throw new RuntimeException("Unrecognized Tree");
    }

    public double getBranchLength(NodeRef nodeRef) {
        return this.getBranchLength(this.tree, nodeRef);
    }

    @Override
    public MutationList getMutations(NodeRef nodeRef) {
        MutationList.SimpleMutationList simpleMutationList = new MutationList.SimpleMutationList(this.getBranchLength(nodeRef));
        return simpleMutationList;
    }

    private HashMap<BitSet, NodeRef> getBitSetNodeMap(Tree tree, Tree tree2) {
        HashMap<BitSet, NodeRef> hashMap = new HashMap<BitSet, NodeRef>();
        this.addBits(tree, tree2, tree2.getRoot(), hashMap);
        return hashMap;
    }

    private BitSet addBits(Tree tree, Tree tree2, NodeRef nodeRef, HashMap hashMap) {
        BitSet bitSet = new BitSet();
        if (tree2.isExternal(nodeRef)) {
            String string = tree2.getNodeTaxon(nodeRef).getId();
            bitSet.set(tree.getTaxonIndex(string));
        } else {
            for (int i = 0; i < tree2.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree2.getChild(nodeRef, i);
                bitSet.or(this.addBits(tree, tree2, nodeRef2, hashMap));
            }
        }
        hashMap.put(bitSet, nodeRef);
        return bitSet;
    }
}

