/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.ConstLogistic;
import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class ConstantLogisticModel
extends DemographicModel
implements Citable {
    private Parameter N0Parameter = null;
    private Parameter N1Parameter = null;
    private Parameter growthRateParameter = null;
    private Parameter shapeParameter = null;
    private double alpha = 0.5;
    private ConstLogistic constLogistic = null;
    public static Citation CITATION = new Citation(new Author[]{new Author("OG", "Pybus"), new Author("A", "Rambaut")}, "GENIE: estimating demographic history from molecular phylogenies", 2001, "Bioinformatics", 18, 1404, 1405);

    public ConstantLogisticModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, double d, Units.Type type) {
        this("constantLogistic", parameter, parameter2, parameter3, parameter4, d, type);
    }

    private ConstantLogisticModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, double d, Units.Type type) {
        super(string);
        this.constLogistic = new ConstLogistic(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.N1Parameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.growthRateParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.shapeParameter = parameter4;
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.alpha = d;
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.constLogistic.setN0(this.N0Parameter.getParameterValue(0));
        this.constLogistic.setN1(this.N1Parameter.getParameterValue(0));
        double d = this.growthRateParameter.getParameterValue(0);
        this.constLogistic.setGrowthRate(d);
        double d2 = (1.0 - this.alpha) * Math.exp(-d * (this.shapeParameter.getParameterValue(0) - this.getTimeOffset())) / this.alpha;
        this.constLogistic.setShape(d2);
        return this.constLogistic;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Constant-Logistic Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

