/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.alignment.PatternList;
import dr.evolution.tree.NodeRef;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.continuous.LatentTruncation;
import dr.evomodel.continuous.SoftThresholdLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.Distribution;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class MultinomialLatentLiabilityLikelihood
extends AbstractModelLikelihood
implements LatentTruncation,
Citable,
SoftThresholdLikelihood {
    public static final String MULTINOMIAL_LATENT_LIABILITY_LIKELIHOOD = "multinomialLatentLiabilityLikelihood";
    private final LatentTruncation.Delegate normalizationDelegate = new LatentTruncation.Delegate(){

        @Override
        protected double computeNormalizationConstant(Distribution distribution) {
            double d = 0.0;
            return d;
        }
    };
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String TIP_TRAIT = "tipTrait";
        public static final String NUM_CLASSES = "numClasses";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(AbstractMultivariateTraitLikelihood.class, "The model for the latent random variables"), new ElementRule("tipTrait", CompoundParameter.class, "The parameter of tip locations from the tree"), new ElementRule("numClasses", Parameter.class, "Number of multinomial classes in each dimention"), new ElementRule(PatternList.class, "The multinomial tip data"), new ElementRule(TreeModel.class, "The tree model")};

        @Override
        public String getParserName() {
            return MultinomialLatentLiabilityLikelihood.MULTINOMIAL_LATENT_LIABILITY_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood = (AbstractMultivariateTraitLikelihood)xMLObject.getChild(AbstractMultivariateTraitLikelihood.class);
            PatternList patternList = (PatternList)xMLObject.getChild(PatternList.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            CompoundParameter compoundParameter = (CompoundParameter)xMLObject.getElementFirstChild(TIP_TRAIT);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(NUM_CLASSES);
            int n = treeModel.getTaxonCount();
            int n2 = abstractMultivariateTraitLikelihood.getNumData();
            int n3 = abstractMultivariateTraitLikelihood.getDimTrait();
            if (compoundParameter.getDimension() != n * n2 * n3) {
                throw new XMLParseException("Tip trait parameter is wrong dimension in latent liability model");
            }
            return new MultinomialLatentLiabilityLikelihood(treeModel, patternList, compoundParameter, parameter);
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of a latent liability model on multivariate trait data";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MultinomialLatentLiabilityLikelihood.class;
        }
    };
    private TreeModel treeModel;
    private PatternList patternList;
    private CompoundParameter tipTraitParameter;
    private Parameter numClasses;
    private int[][] tipData;
    private boolean likelihoodKnown = false;
    private double logLikelihood;
    private double storedLogLikelihood;
    private static final boolean DEBUG = true;
    private double pathParameter = 1.0;

    public MultinomialLatentLiabilityLikelihood(TreeModel treeModel, PatternList patternList, CompoundParameter compoundParameter, Parameter parameter) {
        super(MULTINOMIAL_LATENT_LIABILITY_LIKELIHOOD);
        this.treeModel = treeModel;
        this.patternList = patternList;
        this.tipTraitParameter = compoundParameter;
        this.numClasses = parameter;
        this.addVariable(compoundParameter);
        this.setTipDataValuesForAllNodes();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Constructing a latent liability likelihood model:\n");
        stringBuilder.append("\tBinary patterns: ").append(patternList.getId()).append("\n");
        stringBuilder.append("\tPlease cite:\n").append(Citable.Utils.getCitationString(this));
        Logger.getLogger("dr.evomodel.continous").info(stringBuilder.toString());
    }

    private void setTipDataValuesForAllNodes() {
        if (this.tipData == null) {
            this.tipData = new int[this.treeModel.getExternalNodeCount()][this.patternList.getPatternCount()];
        }
        for (int i = 0; i < this.treeModel.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getExternalNode(i);
            String string = this.treeModel.getTaxonId(i);
            int n = this.patternList.getTaxonIndex(string);
            this.setTipDataValuesForNode(nodeRef, n);
            System.err.println("\t For node: " + i + " with ID " + string + " you get taxon " + n + " with ID " + this.patternList.getTaxonId(n));
        }
    }

    private void setTipDataValuesForNode(NodeRef nodeRef, int n) {
        int n2 = nodeRef.getNumber();
        for (int i = 0; i < this.patternList.getPatternCount(); ++i) {
            this.tipData[n2][i] = this.patternList.getPattern(i)[n];
            Parameter parameter = this.tipTraitParameter.getParameter(n2);
            System.err.println("Data = " + this.tipData[n2][i] + " : " + parameter.getParameterValue(i));
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.computeLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.getLogLikelihood() + ")";
    }

    protected double computeLogLikelihood() {
        boolean bl = true;
        for (int i = 0; i < this.tipData.length && bl; ++i) {
            bl = this.validTraitForTip(i);
        }
        if (bl) {
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public boolean validTraitForTip(int n) {
        boolean bl = true;
        Parameter parameter = this.tipTraitParameter.getParameter(n);
        int[] nArray = this.tipData[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length && bl; ++i) {
            int n3 = nArray[i];
            int n4 = (int)this.numClasses.getParameterValue(i);
            if ((double)n4 == 1.0) {
                bl = true;
                ++n2;
                continue;
            }
            if ((double)n4 == 2.0) {
                double d = parameter.getParameterValue(n2);
                if (d == 0.0) {
                    bl = true;
                } else {
                    boolean bl2;
                    boolean bl3 = bl2 = d > 0.0;
                    bl = bl2 ? (double)n3 == 1.0 : (double)n3 == 0.0;
                }
                ++n2;
                continue;
            }
            double[] dArray = new double[n4];
            for (int j = 0; j < n4; ++j) {
                dArray[j] = parameter.getParameterValue(n2 + j);
            }
            bl = this.isMax(dArray, n3);
            n2 += n4;
        }
        return bl;
    }

    private boolean isMax(double[] dArray, int n) {
        boolean bl = true;
        for (int i = 0; i < dArray.length && bl; ++i) {
            bl = dArray[n] >= dArray[i];
        }
        return bl;
    }

    @Override
    public double getNormalizationConstant(Distribution distribution) {
        return this.normalizationDelegate.getNormalizationConstant(distribution);
    }

    @Override
    public void setPathParameter(double d) {
        this.pathParameter = d;
    }

    @Override
    public double getLikelihoodCorrection() {
        return 0.0;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Latent Liability model";
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        arrayList.add(CommonCitations.CYBIS_2015_ASSESSING);
        return arrayList;
    }
}

