/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.app.gui.ColorFunction;
import dr.geo.GTOPO30Tile;
import dr.geo.Lattice;
import dr.geo.Location;
import dr.geo.RateMatrix;
import dr.math.distributions.GammaDistribution;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JPanel;

public class GTOPO30Panel
extends JPanel
implements Lattice {
    GTOPO30Tile[][] tiles;
    int minLat;
    int maxLat;
    int minLong;
    int maxLong;
    double scale = 0.5;

    public GTOPO30Panel(String[] stringArray, ColorFunction colorFunction) throws IOException {
        ArrayList<GTOPO30Tile> arrayList = new ArrayList<GTOPO30Tile>();
        for (String object2 : stringArray) {
            GTOPO30Tile gTOPO30Tile = new GTOPO30Tile(object2, colorFunction);
            if (gTOPO30Tile.getMaxLatitude() > this.maxLat) {
                this.maxLat = gTOPO30Tile.getMaxLatitude();
            }
            if (gTOPO30Tile.getMaxLongitude() > this.maxLong) {
                this.maxLong = gTOPO30Tile.getMaxLongitude();
            }
            if (gTOPO30Tile.getMinLatitude() < this.minLat) {
                this.minLat = gTOPO30Tile.getMinLatitude();
            }
            if (gTOPO30Tile.getMinLongitude() < this.minLong) {
                this.minLong = gTOPO30Tile.getMinLongitude();
            }
            arrayList.add(gTOPO30Tile);
        }
        this.tiles = new GTOPO30Tile[(this.maxLat - this.minLat) / 50][(this.maxLong - this.minLong) / 40];
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            GTOPO30Tile gTOPO30Tile;
            this.tiles[(this.maxLat - gTOPO30Tile.getMaxLatitude()) / 50][(gTOPO30Tile.getMinLongitude() - this.minLong) / 40] = gTOPO30Tile = (GTOPO30Tile)object.next();
        }
        this.setLayout(new GridLayout(this.tiles.length, this.tiles[0].length));
        object = this.tiles;
        int n = ((Object)object).length;
        for (int i = 0; i < n; ++i) {
            Object object2;
            for (Object object3 : object2 = object[i]) {
                if (object3 != null) {
                    this.add((Component)object3);
                    continue;
                }
                this.add(new JPanel());
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)Math.round((double)(this.tiles[0].length * 4800) * this.scale), (int)Math.round((double)(this.tiles.length * 6000) * this.scale));
    }

    public short getHeight(int n, int n2) {
        int n3 = n / 6000;
        int n4 = n2 / 4800;
        int n5 = n % 6000;
        int n6 = n2 % 4800;
        try {
            short s = this.tiles[n3][n4].getHeight(n5, n6);
            return s;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Error at y=" + n + ", x=" + n2);
            return -1;
        }
    }

    public Location getLocation(double d, double d2) {
        double d3 = (double)this.tiles[0][0].getMaxLatitude() - d;
        double d4 = d2 - (double)this.tiles[0][0].getMinLongitude();
        return new Location((int)Math.round(d4 / this.tiles[0][0].xdim), (int)Math.round(d3 / this.tiles[0][0].ydim));
    }

    public void setScale(double d) {
        this.scale = d;
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    @Override
    public int latticeWidth() {
        return this.tiles[0].length * 4800;
    }

    @Override
    public int latticeHeight() {
        return this.tiles.length * 6000;
    }

    @Override
    public int getState(int n, int n2) {
        return this.getHeight(n2, n) / 100;
    }

    @Override
    public void paintLattice(Graphics graphics) {
        this.paint(graphics);
    }

    public RateMatrix getRates(double d) {
        final double[] dArray = new double[52];
        for (int i = 0; i < dArray.length; ++i) {
            int n = i * 100;
            int n2 = n + 100;
            double d2 = 0.55;
            double d3 = 5800.0;
            dArray[i] = d * (GammaDistribution.cdf(n2, d2, d3) - GammaDistribution.cdf(n, d2, d3));
            System.out.println("toRate[" + i + "] = " + dArray[i]);
        }
        return new RateMatrix(){

            @Override
            public double getRate(int n, int n2) {
                if (n2 < 0 || n2 >= dArray.length) {
                    return 0.0;
                }
                return dArray[n2];
            }
        };
    }
}

