/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.InverseGammaDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InverseGammaDistributionModel
extends AbstractModel
implements ParametricDistributionModel {
    public static final String INVERSE_GAMMA_DISTRIBUTION_MODEL = "inverseGammaDistributionModel";
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return InverseGammaDistributionModel.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return 0.0;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private Variable<Double> shape = null;
    private Variable<Double> scale = null;

    public InverseGammaDistributionModel(Variable<Double> variable, Variable<Double> variable2) {
        super(INVERSE_GAMMA_DISTRIBUTION_MODEL);
        this.shape = variable;
        this.scale = variable2;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    public InverseGammaDistributionModel(Variable<Double> variable) {
        super(INVERSE_GAMMA_DISTRIBUTION_MODEL);
        this.shape = variable;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    @Override
    public double pdf(double d) {
        return InverseGammaDistribution.pdf(d, this.getShape(), this.getScale(), 1.0);
    }

    @Override
    public double logPdf(double d) {
        return InverseGammaDistribution.logPdf(d, this.getShape(), this.getScale(), 1.0);
    }

    @Override
    public double cdf(double d) {
        return InverseGammaDistribution.cdf(d, this.getShape(), this.getScale());
    }

    @Override
    public double quantile(double d) {
        return InverseGammaDistribution.quantile(d, this.getShape(), this.getScale());
    }

    @Override
    public double mean() {
        return InverseGammaDistribution.mean(this.getShape(), this.getScale());
    }

    @Override
    public double variance() {
        return InverseGammaDistribution.variance(this.getShape(), this.getScale());
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    public double getShape() {
        return this.shape.getValue(0);
    }

    public double getScale() {
        return this.scale.getValue(0);
    }
}

