/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ScaledMatrixParameter
extends Parameter.Abstract
implements MatrixParameterInterface,
VariableListener {
    private final MatrixParameterInterface matrixParameter;
    private final Parameter scaleParameter;
    private final double[][] columnBuffers;
    private final double[][] storedColumnBuffers;
    private Boolean valuesKnown = false;
    private Boolean storedValuesKnown = false;
    private final String name;
    private final boolean[] renormalize;
    private boolean doNotPropogateChangesUp = false;
    public static final String SCALED_MATRIX = "scaledMatrixParameter";
    public static final String SCALE = "scale";
    public static final String MATRIX = "matrix";
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(ScaledMatrixParameter.SCALE).getChild(Parameter.class);
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(ScaledMatrixParameter.MATRIX).getChild(MatrixParameterInterface.class);
            String string = xMLObject.hasId() ? xMLObject.getId() : null;
            return new ScaledMatrixParameter(string, matrixParameterInterface, parameter);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(ScaledMatrixParameter.SCALE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule(ScaledMatrixParameter.MATRIX, new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class)})};
        }

        @Override
        public String getParserDescription() {
            return "parameter that scales each column of a matrix";
        }

        @Override
        public Class getReturnType() {
            return ScaledMatrixParameter.class;
        }

        @Override
        public String getParserName() {
            return ScaledMatrixParameter.SCALED_MATRIX;
        }
    };

    public ScaledMatrixParameter(String string, MatrixParameterInterface matrixParameterInterface, Parameter parameter) {
        this.name = string;
        this.matrixParameter = matrixParameterInterface;
        this.scaleParameter = parameter;
        this.columnBuffers = new double[matrixParameterInterface.getColumnDimension()][matrixParameterInterface.getRowDimension()];
        this.storedColumnBuffers = new double[matrixParameterInterface.getColumnDimension()][matrixParameterInterface.getRowDimension()];
        this.renormalize = new boolean[parameter.getDimension()];
        parameter.addParameterListener(this);
        matrixParameterInterface.addParameterListener(this);
    }

    private void updateBuffer() {
        if (!this.valuesKnown.booleanValue()) {
            for (int i = 0; i < this.matrixParameter.getColumnDimension(); ++i) {
                for (int j = 0; j < this.matrixParameter.getRowDimension(); ++j) {
                    this.columnBuffers[i][j] = this.matrixParameter.getParameterValue(j, i) * this.scaleParameter.getParameterValue(i);
                }
            }
            this.valuesKnown = true;
        }
    }

    public MatrixParameterInterface getMatrixParameter() {
        return this.matrixParameter;
    }

    public Parameter getScaleParameter() {
        return this.scaleParameter;
    }

    private void throwInvalidException() {
        throw new RuntimeException("Not a valid state. Must call fireParameterChanged before getting value.");
    }

    @Override
    public double getParameterValue(int n, int n2) {
        if (this.renormalize[n2]) {
            this.throwInvalidException();
        }
        this.updateBuffer();
        return this.columnBuffers[n2][n];
    }

    @Override
    public Parameter getParameter(int n) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public double getParameterValue(int n) {
        this.updateBuffer();
        int n2 = n / this.matrixParameter.getRowDimension();
        if (this.renormalize[n2]) {
            this.throwInvalidException();
        }
        int n3 = n - n2 * this.matrixParameter.getRowDimension();
        return this.columnBuffers[n2][n3];
    }

    @Override
    public void setParameterValue(int n, double d) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getParameterName() {
        return this.name;
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Bounds<Double> getBounds() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        this.matrixParameter.setParameterValueQuietly(n, n2, d);
        this.renormalize[n2] = true;
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, int n2, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double[] getColumnValues(int n) {
        this.updateBuffer();
        return (double[])this.columnBuffers[n].clone();
    }

    @Override
    public double[][] getParameterAsMatrix() {
        this.updateBuffer();
        return (double[][])this.columnBuffers.clone();
    }

    @Override
    public int getDimension() {
        return this.matrixParameter.getDimension();
    }

    @Override
    public int getColumnDimension() {
        return this.matrixParameter.getColumnDimension();
    }

    @Override
    public int getRowDimension() {
        return this.matrixParameter.getRowDimension();
    }

    @Override
    public int getUniqueParameterCount() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Parameter getUniqueParameter(int n) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void copyParameterValues(double[] dArray, int n) {
        this.updateBuffer();
        int n2 = n;
        for (int i = 0; i < this.matrixParameter.getColumnDimension(); ++i) {
            System.arraycopy(this.columnBuffers[i], 0, dArray, n2, this.matrixParameter.getRowDimension());
            n2 += this.matrixParameter.getRowDimension();
        }
    }

    @Override
    public void setAllParameterValuesQuietly(double[] dArray, int n) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String toSymmetricString() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return false;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (!this.doNotPropogateChangesUp) {
            this.fireParameterChangedEvent();
        }
        this.valuesKnown = false;
    }

    @Override
    public void fireParameterChangedEvent() {
        for (int i = 0; i < this.renormalize.length; ++i) {
            int n;
            if (!this.renormalize[i]) continue;
            this.doNotPropogateChangesUp = true;
            double d = 0.0;
            for (n = 0; n < this.matrixParameter.getRowDimension(); ++n) {
                double d2 = this.matrixParameter.getParameterValue(n, i);
                d += d2 * d2;
            }
            d = Math.sqrt(d);
            this.scaleParameter.setParameterValueQuietly(i, d);
            for (n = 0; n < this.matrixParameter.getRowDimension(); ++n) {
                this.matrixParameter.setParameterValue(n, i, this.matrixParameter.getParameterValue(n, i) / d);
            }
            this.renormalize[i] = false;
        }
        if (this.doNotPropogateChangesUp) {
            this.scaleParameter.fireParameterChangedEvent();
            this.matrixParameter.fireParameterChangedEvent();
            this.doNotPropogateChangesUp = false;
        }
        this.fireParameterChangedEvent(-1, Variable.ChangeType.VALUE_CHANGED);
    }

    private void transferBuffer(double[][] dArray, double[][] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            System.arraycopy(dArray[i], 0, dArray2[i], 0, dArray[i].length);
        }
    }

    @Override
    protected void storeValues() {
        this.scaleParameter.storeParameterValues();
        this.matrixParameter.storeParameterValues();
        if (this.valuesKnown.booleanValue()) {
            this.transferBuffer(this.columnBuffers, this.storedColumnBuffers);
        }
        this.storedValuesKnown = this.valuesKnown;
    }

    @Override
    protected void restoreValues() {
        this.scaleParameter.restoreParameterValues();
        this.matrixParameter.restoreParameterValues();
        if (this.storedValuesKnown.booleanValue()) {
            this.transferBuffer(this.storedColumnBuffers, this.columnBuffers);
        }
        this.valuesKnown = this.storedValuesKnown;
    }

    @Override
    protected void acceptValues() {
        this.scaleParameter.acceptParameterValues();
        this.matrixParameter.acceptParameterValues();
    }

    @Override
    public String getDimensionName(int n) {
        int n2 = n / this.matrixParameter.getRowDimension();
        int n3 = n - n2 * this.matrixParameter.getRowDimension();
        return this.getStatisticName() + "." + (n2 + 1) + "." + (n3 + 1);
    }

    @Override
    protected void adoptValues(Parameter parameter) {
        throw new RuntimeException("not implemented");
    }
}

