/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.shrinkage;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.ExponentialTiltedStableDistribution;
import dr.inference.distribution.shrinkage.JointBayesianBridgeDistributionModel;
import dr.inference.model.Parameter;
import dr.math.MathUtils;
import dr.math.distributions.GammaDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Arrays;

public class BayesianBridgePriorSampler {
    public static final String BAYESIAN_BRIDGE_PRIOR_SAMPLER = "bayesianBridgePriorSampler";
    public static final String STEPS = "steps";
    private final Parameter globalScale;
    private final Parameter localScale = new Parameter.Default(1, 10.0);
    private final Parameter regressionExponent;
    private final GammaDistribution globalScalePrior;
    private double[] coefficients;
    private int steps;
    JointBayesianBridgeDistributionModel bridge;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(JointBayesianBridgeDistributionModel.class), new ElementRule(DistributionLikelihood.class), AttributeRule.newIntegerRule("steps")};

        @Override
        public String getParserName() {
            return BayesianBridgePriorSampler.BAYESIAN_BRIDGE_PRIOR_SAMPLER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            JointBayesianBridgeDistributionModel jointBayesianBridgeDistributionModel = (JointBayesianBridgeDistributionModel)xMLObject.getChild(JointBayesianBridgeDistributionModel.class);
            GammaDistribution gammaDistribution = null;
            DistributionLikelihood distributionLikelihood = (DistributionLikelihood)xMLObject.getChild(DistributionLikelihood.class);
            if (distributionLikelihood != null) {
                if (distributionLikelihood.getDistribution() instanceof GammaDistribution) {
                    gammaDistribution = (GammaDistribution)distributionLikelihood.getDistribution();
                } else {
                    throw new XMLParseException("Currently only gamma prior on global scale implemented.");
                }
            }
            int n = xMLObject.getIntegerAttribute(BayesianBridgePriorSampler.STEPS);
            BayesianBridgePriorSampler bayesianBridgePriorSampler = new BayesianBridgePriorSampler(jointBayesianBridgeDistributionModel, gammaDistribution, n);
            return bayesianBridgePriorSampler;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Samples from the prior of a given 'dummy' Bayesian Bridge distribution";
        }

        @Override
        public Class getReturnType() {
            return BayesianBridgePriorSampler.class;
        }
    };

    public BayesianBridgePriorSampler(JointBayesianBridgeDistributionModel jointBayesianBridgeDistributionModel, GammaDistribution gammaDistribution, int n) {
        this.globalScale = new Parameter.Default(1, jointBayesianBridgeDistributionModel.getGlobalScale().getParameterValue(0));
        this.regressionExponent = jointBayesianBridgeDistributionModel.getExponent();
        this.bridge = new JointBayesianBridgeDistributionModel(this.globalScale, this.localScale, this.regressionExponent, jointBayesianBridgeDistributionModel.getSlabWidth(), 1, false);
        this.globalScalePrior = gammaDistribution;
        this.steps = n;
        this.coefficients = new double[this.steps];
        this.sample(this.steps);
    }

    void sample(int n) {
        for (int i = 0; i < n; ++i) {
            this.sampleGlobalScale();
            this.coefficients[i] = MathUtils.nextGaussian() * this.bridge.getStandardDeviation(0);
            this.sampleLocalScale(i);
        }
        Arrays.sort(this.coefficients);
    }

    private void sampleGlobalScale() {
        double d = this.globalScalePrior.getShape();
        double d2 = this.globalScalePrior.getScale();
        double d3 = this.regressionExponent.getParameterValue(0);
        double d4 = GammaDistribution.nextGamma(d, d2);
        double d5 = Math.pow(d4, -1.0 / d3);
        this.globalScale.setParameterValue(0, d5);
    }

    private void sampleLocalScale(int n) {
        double d = this.regressionExponent.getParameterValue(0);
        double d2 = this.globalScale.getParameterValue(0);
        double d3 = ExponentialTiltedStableDistribution.nextTiltedStable(d / 2.0, Math.pow(this.coefficients[n] / d2, 2.0));
        this.localScale.setParameterValueQuietly(0, Math.sqrt(1.0 / (2.0 * d3)));
    }

    public double getEpsilon(double d) {
        double d2 = d / 2.0 + 0.5;
        int n = (int)Math.round((double)this.steps * d2);
        double d3 = this.coefficients[n];
        if (d3 < 0.0) {
            throw new RuntimeException("Target probability too small or need more samples from the prior.");
        }
        return this.coefficients[n];
    }

    public int getSteps() {
        return this.steps;
    }
}

