/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.distributions.MultivariateDistribution;
import dr.util.Transform;

public class TransformedMultivariateDistribution
implements MultivariateDistribution,
GradientProvider {
    private MultivariateDistribution distribution;
    private Transform.MultivariateTransform transform;
    private Transform.MultivariateTransform inverseTransform;

    public TransformedMultivariateDistribution(MultivariateDistribution multivariateDistribution, Transform.MultivariateTransform multivariateTransform) {
        assert (multivariateDistribution instanceof GradientProvider) : "The transformed distribution should be a gradient provider";
        this.distribution = multivariateDistribution;
        this.transform = multivariateTransform;
        this.inverseTransform = new Transform.InverseMultivariate(multivariateTransform);
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.distribution.logPdf(this.transform.transform(dArray, 0, dArray.length)) + this.transform.logJacobian(dArray, 0, dArray.length);
    }

    @Override
    public String getType() {
        return "Transformed." + this.distribution.getType();
    }

    @Override
    public int getDimension() {
        return ((GradientProvider)((Object)this.distribution)).getDimension();
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return this.gradLogPdf((double[])object);
    }

    private double[] gradLogPdf(double[] dArray) {
        double[] dArray2 = this.transform.transform(dArray, 0, dArray.length);
        double[] dArray3 = ((GradientProvider)((Object)this.distribution)).getGradientLogDensity(dArray2);
        return this.updateGradientLogDensity(dArray3, dArray2);
    }

    private double[] updateGradientLogDensity(double[] dArray, double[] dArray2) {
        return this.inverseTransform.updateGradientLogDensity(dArray, dArray2, 0, dArray2.length);
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getMean() {
        throw new RuntimeException("Not yet implemented");
    }
}

