/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class UniformDistribution
implements Distribution,
GradientProvider {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return UniformDistribution.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return UniformDistribution.this.lower;
        }

        @Override
        public final double getUpperBound() {
            return UniformDistribution.this.upper;
        }
    };
    private final double upper;
    private final double lower;

    public UniformDistribution(double d, double d2) {
        this.lower = d;
        this.upper = d2;
        assert (!Double.isInfinite(d)) : "bounds on a uniform distribution cannot be infinite";
        assert (!Double.isInfinite(d2)) : "bounds on a uniform distribution cannot be infinite";
    }

    @Override
    public double pdf(double d) {
        return UniformDistribution.pdf(d, this.lower, this.upper);
    }

    @Override
    public double logPdf(double d) {
        return UniformDistribution.logPdf(d, this.lower, this.upper);
    }

    @Override
    public double cdf(double d) {
        return UniformDistribution.cdf(d, this.lower, this.upper);
    }

    @Override
    public double quantile(double d) {
        return UniformDistribution.quantile(d, this.lower, this.upper);
    }

    @Override
    public double mean() {
        return UniformDistribution.mean(this.lower, this.upper);
    }

    @Override
    public double variance() {
        return UniformDistribution.variance(this.lower, this.upper);
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    public static double pdf(double d, double d2, double d3) {
        return d >= d2 && d <= d3 ? 1.0 / (d3 - d2) : 0.0;
    }

    public static double logPdf(double d, double d2, double d3) {
        if (d < d2 || d > d3) {
            return Double.NEGATIVE_INFINITY;
        }
        return -Math.log(d3 - d2);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d < d2) {
            return 0.0;
        }
        if (d > d3) {
            return 1.0;
        }
        return (d - d2) / (d3 - d2);
    }

    public static double quantile(double d, double d2, double d3) {
        if (!(d >= 0.0) || !(d <= 1.0)) {
            throw new IllegalArgumentException("y must in range [0,1]");
        }
        return d * (d3 - d2) + d2;
    }

    public static double mean(double d, double d2) {
        return (d2 + d) / 2.0;
    }

    public static double variance(double d, double d2) {
        return (d2 - d) * (d2 - d) / 12.0;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = this.gradLogPdf(dArray[i]);
        }
        return dArray2;
    }

    private double gradLogPdf(double d) {
        return d < this.lower || d > this.upper ? Double.NaN : 0.0;
    }
}

