/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.Microsatellite;
import dr.inference.model.Parameter;
import dr.math.ModifiedBesselFirstKind;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.MicrosatelliteModel;

public class NewMicrosatelliteModel
extends MicrosatelliteModel {
    Parameter biasConst;
    private boolean normalize;

    public NewMicrosatelliteModel(Microsatellite microsatellite, FrequencyModel frequencyModel) {
        this(microsatellite, frequencyModel, false);
        this.biasConst = new Parameter.Default(0.5);
    }

    public NewMicrosatelliteModel(Microsatellite microsatellite, FrequencyModel frequencyModel, boolean bl) {
        super("NewMicrosatelliteModel", microsatellite, frequencyModel, null);
        this.normalize = bl;
        this.biasConst = new Parameter.Default(0.5);
        double[] dArray = new double[this.stateCount];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 1.0 / (double)this.stateCount;
        }
        this.freqModel = new FrequencyModel(this.dataType, dArray);
        this.computeStationaryDistribution();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    public void getTransitionProbabilities(double d, double[] dArray) {
        int n;
        int n2;
        int n3 = 0;
        double[] dArray2 = new double[this.stateCount];
        double d2 = this.biasConst.getParameterValue(0);
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            for (n = 0; n < this.stateCount; ++n) {
                int n4 = n2 - n;
                dArray[n3] = Math.exp(-d) * ModifiedBesselFirstKind.bessi(d, Math.abs(n4));
                int n5 = n2;
                dArray2[n5] = dArray2[n5] + dArray[n3];
                ++n3;
            }
        }
        if (this.normalize) {
            n3 = 0;
            for (n2 = 0; n2 < this.stateCount; ++n2) {
                for (n = 0; n < this.stateCount; ++n) {
                    dArray[n3] = dArray[n3] / dArray2[n2];
                    ++n3;
                }
            }
        }
    }

    @Override
    public double[] getRowTransitionProbabilities(double d, int n) {
        double[] dArray = new double[this.stateCount];
        for (int i = 0; i < dArray.length; ++i) {
            int n2 = n - i;
            dArray[i] = Math.exp(-d) * ModifiedBesselFirstKind.bessi(d, Math.abs(n2));
        }
        return dArray;
    }

    @Override
    public double[] getColTransitionProbabilities(double d, int n) {
        double[] dArray = new double[this.stateCount];
        for (int i = 0; i < dArray.length; ++i) {
            int n2 = i - n;
            dArray[i] = Math.exp(-d) * ModifiedBesselFirstKind.bessi(d, Math.abs(n2));
        }
        return dArray;
    }

    @Override
    public double getLogOneTransitionProbabilityEntry(double d, int n, int n2) {
        return Math.log(this.getOneTransitionProbabilityEntry(d, n, n2));
    }

    @Override
    public double getOneTransitionProbabilityEntry(double d, int n, int n2) {
        int n3 = n - n2;
        double d2 = Math.exp(-d) * ModifiedBesselFirstKind.bessi(d, Math.abs(n3));
        return d2;
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void setupRelativeRates() {
    }

    @Override
    public void setupInfinitesimalRates() {
    }

    @Override
    protected void frequenciesChanged() {
    }

    public static void main(String[] stringArray) {
        int n;
        Microsatellite microsatellite = new Microsatellite(1, 5);
        NewMicrosatelliteModel newMicrosatelliteModel = new NewMicrosatelliteModel(microsatellite, null);
        double[] dArray = new double[microsatellite.getStateCount() * microsatellite.getStateCount()];
        newMicrosatelliteModel.getTransitionProbabilities(1.0, dArray);
        int n2 = 0;
        for (int i = 0; i < microsatellite.getStateCount(); ++i) {
            for (n = 0; n < microsatellite.getStateCount(); ++n) {
                System.out.print(dArray[n2++] + " ");
            }
            System.out.println();
        }
        double[] dArray2 = newMicrosatelliteModel.getStationaryDistribution();
        for (n = 0; n < dArray2.length; ++n) {
            System.out.print(dArray2[n] + " ");
        }
    }
}

