/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.io.OutputStream;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class CitationLogHandler
extends StreamHandler {
    private static final CitationLogHandler INSTANCE = new CitationLogHandler();
    private final MessageLogFormatter citationFormatter = new MessageLogFormatter();

    public static CitationLogHandler getHandler(OutputStream outputStream) {
        INSTANCE.setFormatter(CitationLogHandler.INSTANCE.citationFormatter);
        INSTANCE.setOutputStream(outputStream);
        return INSTANCE;
    }

    public static void closeHandler() {
        INSTANCE.flush();
        INSTANCE.close();
    }

    @Override
    public void publish(LogRecord logRecord) {
        super.publish(logRecord);
        this.flush();
    }

    private class MessageLogFormatter
    extends Formatter {
        private final String lineSeparator = System.getProperty("line.separator");

        private MessageLogFormatter() {
        }

        @Override
        public synchronized String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.formatMessage(logRecord));
            stringBuffer.append(this.lineSeparator);
            return stringBuffer.toString();
        }
    }
}

