## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ChinAPIs)
library(ggplot2)
library(dplyr)

## ----china-gdp,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----


china_gdp <- head(get_china_gdp())

print(china_gdp)


## ----china-life-expectancy,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----

life_expectancy <- head(get_china_life_expectancy())

print(life_expectancy)


## ----china-population,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----

china_population <- head(get_china_population())

print(china_population)


## ----hk-population-plot, message=FALSE, warning=FALSE, fig.width=7, fig.height=5----

# Plot total population by district with formatted x-axis labels
hk_population_tbl_df %>%
  arrange(desc(TotalPopulation)) %>%
  ggplot(aes(x = reorder(District_EN, TotalPopulation), y = TotalPopulation)) +
  geom_col(fill = "steelblue") +
  coord_flip() +
  scale_y_continuous(labels = function(x) format(x, big.mark = ",", scientific = FALSE)) +
  labs(
    title = "Total Population by District in Hong Kong",
    x = "District",
    y = "Total Population"
  ) +
  theme_minimal()


