## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## ----message=FALSE, echo=F, warning=F-----------------------------------------
# Load SemanticDistance
library(SemanticDistance)

## ----message=FALSE------------------------------------------------------------
#Start from 
MyCleanList <- clean_monologue_or_list(Unordered_List, wordcol='mytext')
knitr::kable(head(MyCleanList, 10), format = "pipe")

## -----------------------------------------------------------------------------
mydendro <- wordlist_to_network(MyCleanList, output='dendrogram', dist_type='embedding')
print(mydendro)

## ----message=FALSE, warning=FALSE---------------------------------------------
mynetwork <- wordlist_to_network(MyCleanList, output='network', dist_type='embedding')
print(mynetwork)

