## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(cld)

## ----quickstart---------------------------------------------------------------
# Run a pairwise test
test_result <- pairwise.wilcox.test(chickwts$weight, chickwts$feed, exact = FALSE)

# Generate compact letter display
make_cld(test_result)

## ----example-wilcox-----------------------------------------------------------
# Pairwise Wilcoxon rank sum test
result <- pairwise.wilcox.test(chickwts$weight, chickwts$feed, exact = FALSE)
make_cld(result)

## ----example-ttest------------------------------------------------------------
# Pairwise t-test
result2 <- pairwise.t.test(chickwts$weight, chickwts$feed)
make_cld(result2)

## ----output-demo--------------------------------------------------------------
result <- pairwise.wilcox.test(chickwts$weight, chickwts$feed, exact = FALSE)
cld_result <- make_cld(result)

# View result
cld_result

# Access metadata
attributes(cld_result)[c("alpha", "method", "n_comparisons", "n_significant")]

## ----convert------------------------------------------------------------------
# Extract as named character vector
letters_only <- as.character(cld_result)
letters_only

# Convert back to plain data frame (removes metadata)
plain_df <- as.data.frame(cld_result)
class(plain_df)

## ----example-alpha------------------------------------------------------------
result <- pairwise.wilcox.test(chickwts$weight, chickwts$feed, exact = FALSE)

# Standard (alpha = 0.05)
make_cld(result, alpha = 0.05)

# More stringent (alpha = 0.01)
make_cld(result, alpha = 0.01)

