/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti.norta;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdistmulti.BiNormalDonnellyDist;

public abstract class NortaInitDisc {
    protected double rX;
    protected DiscreteDistributionInt dist1;
    protected DiscreteDistributionInt dist2;
    protected double tr;
    protected double mu1;
    protected double mu2;
    protected double sd1;
    protected double sd2;
    private int m1;
    private int m2;
    private double[] p1;
    private double[] p2;
    private double[] z1;
    private double[] z2;

    private String tabToString(double[] tab, String message) {
        String desc = message + "\n [";
        for (int i = 0; i < tab.length; ++i) {
            desc = i == tab.length - 1 ? desc + "]\n" : desc + tab[i] + ",";
        }
        return desc;
    }

    public NortaInitDisc(double rX, DiscreteDistributionInt dist1, DiscreteDistributionInt dist2, double tr) {
        this.rX = rX;
        this.dist1 = dist1;
        this.dist2 = dist2;
        this.tr = tr;
    }

    public abstract double computeCorr();

    public void computeParams() {
        int i;
        this.m1 = this.dist1.inverseFInt(this.tr) + 1;
        this.m2 = this.dist2.inverseFInt(this.tr) + 1;
        int[] y1 = new int[this.m1];
        int[] y2 = new int[this.m2];
        this.p1 = new double[this.m1];
        this.p2 = new double[this.m2];
        double[] f1 = new double[this.m1];
        double[] f2 = new double[this.m2];
        this.z1 = new double[this.m1];
        this.z2 = new double[this.m2];
        double u11 = 0.0;
        double u22 = 0.0;
        for (i = 0; i < this.m1; ++i) {
            y1[i] = i;
            this.p1[i] = this.dist1.prob(y1[i]);
            f1[i] = this.dist1.cdf(y1[i]);
            this.z1[i] = NormalDist.inverseF01(f1[i]);
            if (this.z1[i] == Double.NEGATIVE_INFINITY) {
                this.z1[i] = NormalDist.inverseF01(2.2E-308);
            }
            if (this.z1[i] == Double.POSITIVE_INFINITY) {
                this.z1[i] = NormalDist.inverseF01(1.0 - Math.ulp(1.0));
            }
            this.mu1 += f1[i] * this.p1[i];
            u11 += f1[i] * f1[i] * this.p1[i];
        }
        this.sd1 = Math.sqrt(u11 - this.mu1 * this.mu1);
        for (i = 0; i < this.m2; ++i) {
            y2[i] = i;
            this.p2[i] = this.dist2.prob(y2[i]);
            f2[i] = this.dist2.cdf(y2[i]);
            this.z2[i] = NormalDist.inverseF01(f2[i]);
            if (this.z2[i] == Double.NEGATIVE_INFINITY) {
                this.z2[i] = NormalDist.inverseF01(2.2E-308);
            }
            if (this.z2[i] == Double.POSITIVE_INFINITY) {
                this.z2[i] = NormalDist.inverseF01(1.0 - Math.ulp(1.0));
            }
            this.mu2 += f2[i] * this.p2[i];
            u22 += f2[i] * f2[i] * this.p2[i];
        }
        this.sd2 = Math.sqrt(u22 - this.mu2 * this.mu2);
    }

    public double integ(double r) {
        double gr = 0.0;
        for (int i = 0; i < this.m1 - 1; ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.m2 - 1; ++j) {
                sum += this.p2[j + 1] * BiNormalDonnellyDist.barF(this.z1[i], this.z2[j], r);
            }
            gr += this.p1[i + 1] * sum;
        }
        return gr;
    }

    public double deriv(double r) {
        double c = Math.sqrt(1.0 - r * r);
        double c1 = 2.0 * c * c;
        double gp = 0.0;
        for (int i = 0; i < this.m1 - 1; ++i) {
            double z1sq = this.z1[i] * this.z1[i];
            double t1 = 2.0 * r * this.z1[i];
            double sum = 0.0;
            for (int j = 0; j < this.m2 - 1; ++j) {
                sum += this.p2[j + 1] * Math.exp((t1 * this.z2[j] - z1sq - this.z2[j] * this.z2[j]) / c1);
            }
            gp += this.p1[i + 1] * sum;
        }
        return gp /= Math.PI * 2 * c;
    }

    public String toString() {
        String desc = "";
        desc = desc + "rX = " + this.rX + "\n";
        desc = desc + "tr = " + this.tr + "\n";
        desc = desc + "m1 = " + this.m1 + "\n";
        desc = desc + "m2 = " + this.m2 + "\n";
        desc = desc + "mu1 = " + this.mu1 + "\n";
        desc = desc + "mu2 = " + this.mu2 + "\n";
        desc = desc + "sd1 = " + this.sd1 + "\n";
        desc = desc + "sd2 = " + this.sd2 + "\n";
        desc = desc + this.tabToString(this.p1, "Table p1 : ");
        desc = desc + this.tabToString(this.z1, "Table z1 : ");
        desc = desc + this.tabToString(this.p2, "Table p2 : ");
        desc = desc + this.tabToString(this.z2, "Table z2 : ");
        return desc;
    }
}

