/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import haplotype.SampleHapPairs;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;

public final class SplicedGL
implements GL {
    private final int overlap;
    private final SampleHapPairs haps;
    private final GL gl;

    public SplicedGL(SampleHapPairs sampleHapPairs, GL gL) {
        if (sampleHapPairs.nMarkers() >= gL.nMarkers()) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        int n = sampleHapPairs.nMarkers();
        for (int i = 0; i < n; ++i) {
            if (sampleHapPairs.marker(i).equals(gL.marker(i))) continue;
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (!sampleHapPairs.samples().equals(gL.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        this.overlap = sampleHapPairs.nMarkers();
        this.haps = sampleHapPairs;
        this.gl = gL;
    }

    @Override
    public boolean isRefData() {
        return this.gl.isRefData();
    }

    @Override
    public float gl(int n, int n2, int n3, int n4) {
        if (n < this.overlap) {
            int n5 = this.haps.allele1(n, n2);
            int n6 = this.haps.allele2(n, n2);
            return n3 == n5 && n4 == n6 ? 1.0f : 0.0f;
        }
        return this.gl.gl(n, n2, n3, n4);
    }

    @Override
    public boolean isPhased(int n, int n2) {
        if (n < this.overlap) {
            return true;
        }
        return this.gl.isPhased(n, n2);
    }

    @Override
    public int allele1(int n, int n2) {
        if (n < this.overlap) {
            return this.haps.allele1(n, n2);
        }
        return this.gl.allele1(n, n2);
    }

    @Override
    public int allele2(int n, int n2) {
        if (n < this.overlap) {
            return this.haps.allele2(n, n2);
        }
        return this.gl.allele2(n, n2);
    }

    @Override
    public int allele(int n, int n2) {
        if (n < this.overlap) {
            return this.haps.allele(n, n2);
        }
        return this.gl.allele(n, n2);
    }

    @Override
    public Marker marker(int n) {
        return this.gl.marker(n);
    }

    @Override
    public Markers markers() {
        return this.gl.markers();
    }

    @Override
    public int nMarkers() {
        return this.gl.nMarkers();
    }

    @Override
    public int nHaps() {
        return this.gl.nHaps();
    }

    @Override
    public int nSamples() {
        return this.gl.nSamples();
    }

    @Override
    public Samples samples() {
        return this.gl.samples();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append("SplicedGL: nSamples=");
        stringBuilder.append(this.nSamples());
        return stringBuilder.toString();
    }
}

